/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.datastore.sink;

import com.google.datastore.v1.Entity;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.annotation.Requirements;
import io.cdap.cdap.api.data.batch.Output;
import io.cdap.cdap.api.data.batch.OutputFormatProvider;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.dataset.lib.KeyValue;
import io.cdap.cdap.etl.api.Emitter;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.StageConfigurer;
import io.cdap.cdap.etl.api.batch.BatchContext;
import io.cdap.cdap.etl.api.batch.BatchRuntimeContext;
import io.cdap.cdap.etl.api.batch.BatchSink;
import io.cdap.cdap.etl.api.batch.BatchSinkContext;
import io.cdap.plugin.common.LineageRecorder;
import io.cdap.plugin.gcp.datastore.sink.DatastoreOutputFormatProvider;
import io.cdap.plugin.gcp.datastore.sink.DatastoreSinkConfig;
import io.cdap.plugin.gcp.datastore.sink.RecordToEntityTransformer;
import java.util.stream.Collectors;
import org.apache.hadoop.io.NullWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(type="batchsink")
@Name(value="Datastore")
@Description(value="CDAP Google Cloud Datastore Batch Sink takes the structured record from the input source and writes to Google Cloud Datastore.")
@Requirements(capabilities={"bypass_cmek_check"})
public class DatastoreSink
extends BatchSink<StructuredRecord, NullWritable, Entity> {
    private static final Logger LOG = LoggerFactory.getLogger(DatastoreSink.class);
    public static final String PLUGIN_NAME = "Datastore";
    private final DatastoreSinkConfig config;
    private RecordToEntityTransformer recordToEntityTransformer;

    public DatastoreSink(DatastoreSinkConfig config) {
        this.config = config;
    }

    public void configurePipeline(PipelineConfigurer pipelineConfigurer) {
        super.configurePipeline(pipelineConfigurer);
        StageConfigurer configurer = pipelineConfigurer.getStageConfigurer();
        Schema inputSchema = configurer.getInputSchema();
        FailureCollector collector = configurer.getFailureCollector();
        this.config.validate(inputSchema, collector);
    }

    public void prepareRun(BatchSinkContext context) {
        Schema inputSchema = context.getInputSchema();
        LOG.debug("DatastoreSink `prepareRun` input schema: {}", (Object)inputSchema);
        FailureCollector collector = context.getFailureCollector();
        this.config.validate(inputSchema, collector);
        collector.getOrThrowException();
        String project = this.config.getProject();
        String serviceAccount = this.config.getServiceAccount();
        String shouldAutoGenerateKey = Boolean.toString(this.config.shouldUseAutoGeneratedKey(collector));
        String batchSize = Integer.toString(this.config.getBatchSize());
        String shouldUseTransactions = Boolean.toString(this.config.shouldUseTransactions());
        context.addOutput(Output.of((String)this.config.getReferenceName(), (OutputFormatProvider)new DatastoreOutputFormatProvider(project, serviceAccount, this.config.isServiceAccountFilePath(), shouldAutoGenerateKey, batchSize, shouldUseTransactions)));
        LineageRecorder lineageRecorder = new LineageRecorder((BatchContext)context, this.config.getReferenceName());
        lineageRecorder.createExternalDataset(inputSchema);
        lineageRecorder.recordWrite("Write", "Wrote to Cloud Datastore sink", inputSchema.getFields().stream().map(Schema.Field::getName).collect(Collectors.toList()));
    }

    public void initialize(BatchRuntimeContext context) throws Exception {
        super.initialize(context);
        FailureCollector collector = context.getFailureCollector();
        this.recordToEntityTransformer = new RecordToEntityTransformer(this.config.getProject(), this.config.getNamespace(), this.config.getKind(), this.config.getKeyType(collector), this.config.getKeyAlias(), this.config.getAncestor(collector), this.config.getIndexStrategy(collector), this.config.getIndexedProperties());
    }

    public void transform(StructuredRecord record, Emitter<KeyValue<NullWritable, Entity>> emitter) {
        Entity entity = this.recordToEntityTransformer.transformStructuredRecord(record);
        emitter.emit((Object)new KeyValue(null, (Object)entity));
    }
}

