/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.datastore.sink.util;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum IndexStrategy {
    ALL("All"),
    NONE("None"),
    CUSTOM("Custom");

    private final String value;

    private IndexStrategy(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static Optional<IndexStrategy> fromValue(String stringValue) {
        return Stream.of(IndexStrategy.values()).filter(indexStrategy -> indexStrategy.value.equalsIgnoreCase(stringValue)).findAny();
    }

    public static String getSupportedStrategies() {
        return Arrays.stream(IndexStrategy.values()).map(IndexStrategy::getValue).collect(Collectors.joining(", "));
    }
}

