/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.datastore.sink.util;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SinkKeyType {
    AUTO_GENERATED_KEY("Auto-generated key"),
    CUSTOM_NAME("Custom name"),
    KEY_LITERAL("Key literal"),
    URL_SAFE_KEY("URL-safe key");

    private final String value;

    private SinkKeyType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static Optional<SinkKeyType> fromValue(String stringValue) {
        return Stream.of(SinkKeyType.values()).filter(keyType -> keyType.value.equalsIgnoreCase(stringValue)).findAny();
    }

    public static String getSupportedTypes() {
        return Arrays.stream(SinkKeyType.values()).map(SinkKeyType::getValue).collect(Collectors.joining(", "));
    }
}

