/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.datastore.source;

import com.google.datastore.v1.Entity;
import com.google.datastore.v1.PartitionId;
import com.google.datastore.v1.Query;
import com.google.datastore.v1.client.Datastore;
import com.google.datastore.v1.client.DatastoreException;
import com.google.datastore.v1.client.DatastoreHelper;
import com.google.datastore.v1.client.QuerySplitter;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import io.cdap.plugin.gcp.datastore.exception.DatastoreExecutionException;
import io.cdap.plugin.gcp.datastore.source.DatastoreRecordReader;
import io.cdap.plugin.gcp.datastore.source.QueryInputSplit;
import io.cdap.plugin.gcp.datastore.util.DatastoreUtil;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastoreInputFormat
extends InputFormat<LongWritable, Entity> {
    private static final Logger LOG = LoggerFactory.getLogger(DatastoreInputFormat.class);

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException {
        Configuration config = jobContext.getConfiguration();
        String queryString = config.get("mapred.gcd.input.query");
        Query.Builder queryBuilder = Query.newBuilder();
        TextFormat.merge((CharSequence)queryString, (Message.Builder)queryBuilder);
        Query query = queryBuilder.build();
        LOG.debug("Query to be split: {}", (Object)query);
        PartitionId partitionId = PartitionId.newBuilder().setNamespaceId(config.get("mapred.gcd.input.namespace")).setProjectId(config.get("mapred.gcd.input.project")).build();
        int numSplits = config.getInt("mapred.gcd.input.num.splits", 1);
        Datastore datastore = DatastoreUtil.getDatastoreV1(config.get("mapred.gcd.input.service.account"), config.getBoolean("mapred.gcd.input.service.account.isfile", true), config.get("mapred.gcd.input.project"));
        QuerySplitter querySplitter = DatastoreHelper.getQuerySplitter();
        try {
            List splits = querySplitter.getSplits(query, partitionId, numSplits, datastore);
            LOG.debug("Split query into {} splits, requested number of splits: {}", (Object)splits.size(), (Object)numSplits);
            return splits.stream().map(QueryInputSplit::new).collect(Collectors.toList());
        }
        catch (DatastoreException e) {
            throw new DatastoreExecutionException("Unable to split the query: " + query, e);
        }
    }

    public RecordReader<LongWritable, Entity> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
        return new DatastoreRecordReader();
    }
}

