/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.datastore.source;

import com.google.datastore.v1.Entity;
import com.google.datastore.v1.EntityResult;
import com.google.datastore.v1.PartitionId;
import com.google.datastore.v1.Query;
import com.google.datastore.v1.QueryResultBatch;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.client.Datastore;
import com.google.datastore.v1.client.DatastoreException;
import com.google.protobuf.ByteString;
import io.cdap.plugin.gcp.datastore.source.QueryInputSplit;
import io.cdap.plugin.gcp.datastore.util.DatastoreUtil;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormatCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastoreRecordReader
extends RecordReader<LongWritable, Entity> {
    private static final Logger LOG = LoggerFactory.getLogger(DatastoreRecordReader.class);
    private ByteString cursor = ByteString.EMPTY;
    private Counter batchSizeCounter;
    private Datastore datastore;
    private Iterator<EntityResult> results;
    private Entity entity;
    private long index;
    private LongWritable key;
    private PartitionId partitionId;
    private Query query;
    private QueryResultBatch.MoreResultsType lastBatchMoreResultsType;

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException {
        Configuration config = taskAttemptContext.getConfiguration();
        this.query = ((QueryInputSplit)inputSplit).getQuery();
        this.batchSizeCounter = taskAttemptContext.getCounter((Enum)FileInputFormatCounter.BYTES_READ);
        this.datastore = DatastoreUtil.getDatastoreV1(config.get("mapred.gcd.input.service.account"), config.getBoolean("mapred.gcd.input.service.account.isfile", true), config.get("mapred.gcd.input.project"));
        this.partitionId = PartitionId.newBuilder().setNamespaceId(config.get("mapred.gcd.input.namespace")).setProjectId(config.get("mapred.gcd.input.project")).build();
        this.loadPage();
        this.index = 0L;
    }

    public boolean nextKeyValue() throws IOException {
        if (!this.results.hasNext() && this.lastBatchMoreResultsType != QueryResultBatch.MoreResultsType.NO_MORE_RESULTS) {
            this.loadPage();
        }
        if (this.results.hasNext()) {
            this.entity = this.results.next().getEntity();
            this.key = new LongWritable(this.index);
            ++this.index;
            return true;
        }
        return false;
    }

    public LongWritable getCurrentKey() {
        return this.key;
    }

    public Entity getCurrentValue() {
        return this.entity;
    }

    public float getProgress() {
        return 0.0f;
    }

    public void close() {
    }

    private void loadPage() throws IOException {
        Query.Builder queryBuilder = this.query.toBuilder();
        queryBuilder.setStartCursor(this.cursor);
        RunQueryRequest request = RunQueryRequest.newBuilder().setQuery(queryBuilder).setPartitionId(this.partitionId).build();
        LOG.trace("Using start cursor {}; executing query split {}", (Object)this.cursor, (Object)this.query);
        try {
            QueryResultBatch batch = this.datastore.runQuery(request).getBatch();
            this.batchSizeCounter.increment((long)batch.getSerializedSize());
            this.lastBatchMoreResultsType = batch.getMoreResults();
            LOG.trace("Loaded batch of {} entries from Datastore; more results status: {}", (Object)batch.getEntityResultsList().size(), (Object)this.lastBatchMoreResultsType);
            this.cursor = batch.getEndCursor();
            this.results = batch.getEntityResultsList().iterator();
        }
        catch (DatastoreException e) {
            throw new IOException("Failed to run query", e);
        }
    }
}

