/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.datastore.source;

import com.google.datastore.v1.Query;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class QueryInputSplit
extends InputSplit
implements Writable {
    private Query query;

    public QueryInputSplit() {
    }

    public QueryInputSplit(Query query) {
        this.query = query;
    }

    public void write(DataOutput dataOutput) throws IOException {
        byte[] bytes = this.query.toByteArray();
        dataOutput.writeInt(bytes.length);
        dataOutput.write(bytes);
    }

    public void readFields(DataInput dataInput) throws IOException {
        int length = dataInput.readInt();
        byte[] bytes = new byte[length];
        dataInput.readFully(bytes);
        this.query = Query.parseFrom((byte[])bytes);
    }

    public long getLength() {
        return 0L;
    }

    public String[] getLocations() {
        return new String[0];
    }

    public Query getQuery() {
        return this.query;
    }
}

