/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.datastore.source.util;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SourceKeyType {
    NONE("None"),
    KEY_LITERAL("Key literal"),
    URL_SAFE_KEY("URL-safe key");

    private final String value;

    private SourceKeyType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static Optional<SourceKeyType> fromValue(String stringValue) {
        return Stream.of(SourceKeyType.values()).filter(keyType -> keyType.value.equalsIgnoreCase(stringValue)).findAny();
    }

    public static String getSupportedTypes() {
        return Arrays.stream(SourceKeyType.values()).map(SourceKeyType::getValue).collect(Collectors.joining(", "));
    }
}

