/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.datastore.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.datastore.v1.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class DatastorePropertyUtil {
    private static final Pattern KEY_PATTERN = Pattern.compile("\\s*key\\s*\\((.*)\\)\\s*", 2);
    public static final String DEFAULT_NAMESPACE = "";

    public static String getNamespace(@Nullable String namespace) {
        return Strings.isNullOrEmpty((String)namespace) || namespace.equalsIgnoreCase("default") ? DEFAULT_NAMESPACE : namespace;
    }

    public static List<Key.PathElement> parseKeyLiteral(String keyLiteral) {
        if (Strings.isNullOrEmpty((String)keyLiteral)) {
            return Collections.emptyList();
        }
        Matcher matcher = KEY_PATTERN.matcher(keyLiteral);
        if (!matcher.find()) {
            throw new IllegalArgumentException(String.format("Unsupported datastore key literal format: '%s'. Expected format: %s", keyLiteral, "key(kind, identifier, kind, identifier, [...])"));
        }
        try {
            String keyString = matcher.group(1);
            String[] keyArray = keyString.split(",");
            Preconditions.checkState((keyArray.length % 2 == 0 ? 1 : 0) != 0, (Object)"Key literal must have even number of elements");
            ArrayList<Key.PathElement> resultList = new ArrayList<Key.PathElement>(keyArray.length / 2);
            for (int i = 0; i < keyArray.length; i += 2) {
                String kind = keyArray[i].trim().replaceAll("`", DEFAULT_NAMESPACE);
                String identifier = keyArray[i + 1].trim();
                Key.PathElement pathElement = identifier.contains("'") ? Key.PathElement.newBuilder().setKind(kind).setName(identifier.replaceAll("'", DEFAULT_NAMESPACE)).build() : Key.PathElement.newBuilder().setKind(kind).setId(Long.valueOf(identifier).longValue()).build();
                resultList.add(pathElement);
            }
            return resultList;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid Datastore key literal '%s'. Expected format: '%s'", keyLiteral, "key(kind, identifier, kind, identifier, [...])"), e);
        }
    }

    public static String getKeyAlias(@Nullable String keyAlias) {
        return Strings.isNullOrEmpty((String)keyAlias) ? "__key__" : keyAlias;
    }
}

