/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.datastore.util;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.common.base.Strings;
import com.google.datastore.v1.client.Datastore;
import com.google.datastore.v1.client.DatastoreFactory;
import com.google.datastore.v1.client.DatastoreOptions;
import io.cdap.plugin.gcp.datastore.exception.DatastoreInitializationException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastoreUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DatastoreUtil.class);

    public static Datastore getDatastoreV1(@Nullable String serviceAccount, @Nullable Boolean isServiceAccountFilePath, String projectId) {
        try {
            Credential credential = DatastoreUtil.getCredential(serviceAccount, isServiceAccountFilePath);
            DatastoreOptions options = new DatastoreOptions.Builder().credential(credential).projectId(projectId).build();
            return DatastoreFactory.get().create(options);
        }
        catch (IOException e) {
            throw new DatastoreInitializationException("Unable to connect to Datastore V1", e);
        }
    }

    private static Credential getCredential(@Nullable String serviceAccount, @Nullable Boolean isServiceAccountFilePath) throws IOException {
        GoogleCredential credential = !Strings.isNullOrEmpty((String)serviceAccount) ? (!isServiceAccountFilePath.booleanValue() ? DatastoreUtil.loadCredentialFromStream(serviceAccount) : DatastoreUtil.loadCredentialFromFile(serviceAccount)) : GoogleCredential.getApplicationDefault();
        return credential.createScoped((Collection)DatastoreOptions.SCOPES);
    }

    private static GoogleCredential loadCredentialFromFile(@Nullable String serviceAccountFilePath) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(serviceAccountFilePath);){
            GoogleCredential googleCredential = GoogleCredential.fromStream((InputStream)inputStream);
            return googleCredential;
        }
    }

    private static GoogleCredential loadCredentialFromStream(@Nullable String serviceAccount) throws IOException {
        try (ByteArrayInputStream jsonInputStream = new ByteArrayInputStream(serviceAccount.getBytes());){
            GoogleCredential googleCredential = GoogleCredential.fromStream((InputStream)jsonInputStream);
            return googleCredential;
        }
    }
}

