/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.gcs;

import com.google.common.net.UrlEscapers;
import java.net.URI;
import java.util.Objects;
import java.util.regex.Pattern;

public class GCSPath {
    public static final String ROOT_DIR = "/";
    public static final String SCHEME = "gs://";
    private final URI uri;
    private final String bucket;
    private final String name;

    private GCSPath(URI uri, String bucket, String name) {
        this.uri = uri;
        this.bucket = bucket;
        this.name = name;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getName() {
        return this.name;
    }

    boolean isBucket() {
        return this.name.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GCSPath gcsPath = (GCSPath)o;
        return Objects.equals(this.uri, gcsPath.uri) && Objects.equals(this.bucket, gcsPath.bucket) && Objects.equals(this.name, gcsPath.name);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.bucket, this.name);
    }

    public static GCSPath from(String path) {
        if (path.isEmpty()) {
            throw new IllegalArgumentException("GCS path can not be empty. The path must be of form 'gs://<bucket-name>/path'.");
        }
        if (path.startsWith(ROOT_DIR)) {
            path = path.substring(1);
        } else if (path.startsWith(SCHEME)) {
            path = path.substring(SCHEME.length());
        }
        String bucket = path;
        int idx = path.indexOf(ROOT_DIR);
        if (idx > 0) {
            bucket = path.substring(0, idx);
        }
        if (!Pattern.matches("[a-z0-9-_.]+", bucket)) {
            throw new IllegalArgumentException(String.format("Invalid bucket name in path '%s'. Bucket name should only contain lower case alphanumeric, '-'. '_' and '.'. Please follow GCS naming convention: https://cloud.google.com/storage/docs/naming-buckets", path));
        }
        String file = idx > 0 ? path.substring(idx).replaceAll("^/", "") : "";
        URI uri = URI.create(SCHEME + bucket + ROOT_DIR + UrlEscapers.urlFragmentEscaper().escape(file));
        return new GCSPath(uri, bucket, file);
    }
}

