/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.gcs;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import io.cdap.plugin.gcp.common.GCPUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;

public class ServiceAccountAccessTokenProvider
implements AccessTokenProvider {
    private Configuration conf;
    private GoogleCredentials credentials;

    public AccessTokenProvider.AccessToken getAccessToken() {
        try {
            AccessToken token = this.getCredentials().getAccessToken();
            if (token == null || token.getExpirationTime().before(Date.from(Instant.now()))) {
                this.refresh();
                token = this.getCredentials().getAccessToken();
            }
            return new AccessTokenProvider.AccessToken(token.getTokenValue(), Long.valueOf(token.getExpirationTime().getTime()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void refresh() throws IOException {
        this.getCredentials().refresh();
    }

    private GoogleCredentials getCredentials() throws IOException {
        if (this.credentials == null) {
            this.credentials = GCPUtils.loadCredentialsFromConf(this.conf);
        }
        return this.credentials;
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

