/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.gcs.actions;

import com.google.auth.Credentials;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.common.base.Joiner;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.StageConfigurer;
import io.cdap.cdap.etl.api.action.Action;
import io.cdap.cdap.etl.api.action.ActionContext;
import io.cdap.plugin.gcp.common.GCPUtils;
import io.cdap.plugin.gcp.gcs.GCSPath;
import io.cdap.plugin.gcp.gcs.actions.GCSArgumentSetterConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Plugin(type="action")
@Name(value="GCSArgumentSetter")
@Description(value="Argument setter for dynamically configuring pipeline from GCS")
public final class GCSArgumentSetter
extends Action {
    public static final String NAME = "GCSArgumentSetter";
    private GCSArgumentSetterConfig config;

    public void configurePipeline(PipelineConfigurer configurer) {
        super.configurePipeline(configurer);
        StageConfigurer stageConfigurer = configurer.getStageConfigurer();
        FailureCollector collector = stageConfigurer.getFailureCollector();
        this.config.validate(collector);
    }

    public void run(ActionContext context) throws Exception {
        this.config.validateProperties(context.getFailureCollector());
        String fileContent = GCSArgumentSetter.getContent(this.config);
        try {
            Configuration configuration = (Configuration)new GsonBuilder().create().fromJson(fileContent, Configuration.class);
            for (Argument argument : configuration.getArguments()) {
                String name = argument.getName();
                String value = argument.getValue();
                if (value != null) {
                    context.getArguments().set(name, value);
                    continue;
                }
                throw new RuntimeException("Configuration '" + name + "' is null. Cannot set argument to null.");
            }
        }
        catch (JsonSyntaxException e) {
            throw new RuntimeException(String.format("Could not parse response from '%s': %s", this.config.getPath(), e.getMessage()));
        }
    }

    private static Storage getStorage(GCSArgumentSetterConfig config) throws IOException {
        String serviceAccount = config.getServiceAccount();
        StorageOptions.Builder builder = (StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(config.getProject());
        if (serviceAccount != null) {
            builder.setCredentials((Credentials)GCPUtils.loadServiceAccountCredentials(serviceAccount, config.isServiceAccountFilePath()));
        }
        return (Storage)builder.build().getService();
    }

    public static String getContent(GCSArgumentSetterConfig config) throws IOException {
        Storage storage = GCSArgumentSetter.getStorage(config);
        GCSPath path = config.getPath();
        Blob blob = storage.get(path.getBucket(), path.getName(), new Storage.BlobGetOption[0]);
        return new String(blob.getContent(new Blob.BlobSourceOption[0]));
    }

    private static final class Argument {
        private String name;
        private String type = "string";
        private JsonElement value;

        Argument() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            if (this.value == null) {
                throw new IllegalArgumentException("Null Argument value for name '" + this.name + "'");
            }
            if (this.type.equalsIgnoreCase("schema")) {
                return this.createSchema(this.value).toString();
            }
            if (this.type.equalsIgnoreCase("int")) {
                return Integer.toString(this.value.getAsInt());
            }
            if (this.type.equalsIgnoreCase("float")) {
                return Float.toString(this.value.getAsFloat());
            }
            if (this.type.equalsIgnoreCase("double")) {
                return Double.toString(this.value.getAsDouble());
            }
            if (this.type.equalsIgnoreCase("short")) {
                return Short.toString(this.value.getAsShort());
            }
            if (this.type.equalsIgnoreCase("string")) {
                return this.value.getAsString();
            }
            if (this.type.equalsIgnoreCase("char")) {
                return Character.toString(this.value.getAsCharacter());
            }
            if (this.type.equalsIgnoreCase("array")) {
                ArrayList<String> values = new ArrayList<String>();
                for (JsonElement v : this.value.getAsJsonArray()) {
                    values.add(v.getAsString());
                }
                return Joiner.on((String)"\n").join(values);
            }
            if (this.type.equalsIgnoreCase("map")) {
                ArrayList<String> values = new ArrayList<String>();
                for (Map.Entry entry : this.value.getAsJsonObject().entrySet()) {
                    values.add(String.format("%s=%s", entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
                }
                return Joiner.on((String)";").join(values);
            }
            throw new IllegalArgumentException("Invalid argument value '" + this.value + "'");
        }

        private Schema createSchema(JsonElement array) {
            ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
            for (JsonElement field : array.getAsJsonArray()) {
                Schema.Type type = Schema.Type.STRING;
                JsonObject object = field.getAsJsonObject();
                String fieldType = object.get("type").getAsString().toLowerCase();
                boolean isNullable = true;
                if (object.get("nullable") != null) {
                    isNullable = object.get("nullable").getAsBoolean();
                }
                String name = object.get("name").getAsString();
                if (fieldType.equals("double")) {
                    type = Schema.Type.DOUBLE;
                } else if (fieldType.equals("float")) {
                    type = Schema.Type.FLOAT;
                } else if (fieldType.equals("long")) {
                    type = Schema.Type.LONG;
                } else if (fieldType.equals("int")) {
                    type = Schema.Type.INT;
                } else if (fieldType.equals("short")) {
                    type = Schema.Type.INT;
                } else if (fieldType.equals("string")) {
                    type = Schema.Type.STRING;
                }
                Schema schema = isNullable ? Schema.nullableOf((Schema)Schema.of((Schema.Type)type)) : Schema.of((Schema.Type)type);
                Schema.Field fld = Schema.Field.of((String)name, (Schema)schema);
                fields.add(fld);
            }
            return Schema.recordOf((String)"record", fields);
        }
    }

    private static final class Configuration {
        private List<Argument> arguments;

        private Configuration() {
        }

        public List<Argument> getArguments() {
            return this.arguments;
        }
    }
}

