/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.gcs.actions;

import com.google.common.base.Strings;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.gcp.common.GCPConfig;
import io.cdap.plugin.gcp.gcs.GCSPath;
import io.cdap.plugin.gcp.gcs.actions.GCSArgumentSetter;

public final class GCSArgumentSetterConfig
extends GCPConfig {
    public static final String NAME_PATH = "path";
    @Name(value="path")
    @Macro
    @Description(value="GCS Path to the file containing the arguments")
    private String path;

    public void validate(FailureCollector collector) {
        this.validateProperties(collector);
        if (this.canConnect()) {
            try {
                GCSArgumentSetter.getContent(this);
            }
            catch (Exception e) {
                collector.addFailure("Can not get content from GCP!", null);
            }
        }
        collector.getOrThrowException();
    }

    public void validateProperties(FailureCollector collector) {
        Boolean isServiceAccountJson;
        if (!this.containsMacro(NAME_PATH)) {
            try {
                this.getPath();
            }
            catch (IllegalArgumentException e) {
                collector.addFailure(e.getMessage(), null).withConfigProperty(NAME_PATH);
            }
        }
        if ((isServiceAccountJson = this.isServiceAccountJson()) != null && isServiceAccountJson.booleanValue() && !this.containsMacro("serviceAccountJSON") && Strings.isNullOrEmpty((String)this.getServiceAccountJson())) {
            collector.addFailure("Required property 'Service Account JSON' has no value.", "").withConfigProperty("serviceAccountJSON");
        }
    }

    private boolean canConnect() {
        boolean canConnect;
        boolean bl = canConnect = !this.containsMacro(NAME_PATH) && !this.containsMacro("project") && !"auto-detect".equals(this.project) && !this.containsMacro("serviceAccountType");
        if (!canConnect) {
            return false;
        }
        if (!this.isServiceAccountJson().booleanValue()) {
            return !this.containsMacro("serviceFilePath") && !Strings.isNullOrEmpty((String)this.getServiceAccountFilePath());
        }
        return !this.containsMacro("serviceAccountJSON") && !Strings.isNullOrEmpty((String)this.getServiceAccountJson());
    }

    public GCSPath getPath() {
        return GCSPath.from(this.path);
    }
}

