/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.gcs.actions;

import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.action.Action;
import io.cdap.cdap.etl.api.action.ActionContext;
import io.cdap.plugin.gcp.common.GCPConfig;
import io.cdap.plugin.gcp.common.GCPUtils;
import io.cdap.plugin.gcp.gcs.GCSPath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(type="action")
@Name(value="GCSBucketDelete")
@Description(value="Deletes objects from a Google Cloud Storage bucket")
public final class GCSBucketDelete
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(GCSBucketDelete.class);
    public static final String NAME = "GCSBucketDelete";
    private Config config;

    public void configurePipeline(PipelineConfigurer pipelineConfigurer) {
        this.config.validate(pipelineConfigurer.getStageConfigurer().getFailureCollector());
    }

    public void run(ActionContext context) throws Exception {
        FileSystem fs;
        this.config.validate(context.getFailureCollector());
        Configuration configuration = new Configuration();
        Boolean isServiceAccountFilePath = this.config.isServiceAccountFilePath();
        if (isServiceAccountFilePath == null) {
            context.getFailureCollector().addFailure("Service account type is undefined.", "Must be `File Path` or `JSON`");
            context.getFailureCollector().getOrThrowException();
            return;
        }
        String serviceAccount = this.config.getServiceAccount();
        GoogleCredentials credentials = serviceAccount == null ? null : GCPUtils.loadServiceAccountCredentials(serviceAccount, isServiceAccountFilePath);
        Map<String, String> map = GCPUtils.generateGCSAuthProperties(serviceAccount, this.config.getServiceAccountType());
        map.forEach((arg_0, arg_1) -> ((Configuration)configuration).set(arg_0, arg_1));
        configuration.set("fs.gs.impl", "com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem");
        configuration.set("fs.AbstractFileSystem.gs.impl", "com.google.cloud.hadoop.fs.gcs.GoogleHadoopFS");
        String projectId = this.config.getProject();
        configuration.set("fs.gs.project.id", projectId);
        configuration.set("fs.gs.path.encoding", "uri-path");
        configuration.setBoolean("fs.gs.impl.disable.cache", true);
        ArrayList<String> gcsPaths = new ArrayList<String>();
        ArrayList<String> gcsPathsWild = new ArrayList<String>();
        Storage storage = GCPUtils.getStorage(this.config.getProject(), (Credentials)credentials);
        for (String path : this.config.getPaths()) {
            GCSPath gcsPath = GCSPath.from(path);
            try {
                storage.get(gcsPath.getBucket(), new Storage.BucketGetOption[0]);
            }
            catch (StorageException e) {
                throw new RuntimeException(String.format("Unable to access or create bucket %s. ", gcsPath.getBucket()) + "Ensure you entered the correct bucket path and have permissions for it.", e);
            }
            String exactGCSPath = "gs://" + gcsPath.getBucket() + "/" + gcsPath.getName();
            if (exactGCSPath.contains("*")) {
                gcsPathsWild.add(exactGCSPath);
                continue;
            }
            gcsPaths.add(exactGCSPath);
        }
        int deleteCount = 0;
        for (String gcsPathStr : gcsPaths) {
            Path gcsPath = new Path(gcsPathStr);
            try {
                fs = gcsPath.getFileSystem(configuration);
            }
            catch (IOException e) {
                LOG.info("Failed deleting file " + gcsPathStr + ", " + e.getMessage());
                continue;
            }
            if (!fs.exists(gcsPath)) continue;
            try {
                fs.delete(gcsPath, true);
                ++deleteCount;
            }
            catch (IOException e) {
                LOG.warn(String.format("Failed to delete path '%s'", gcsPathStr));
            }
        }
        for (String gcsPathStr : gcsPathsWild) {
            String regex = ("\\Q" + gcsPathStr + "\\E").replace("*", "\\E[^/]*\\Q") + "(/.*)?";
            Path gcsPath = new Path(gcsPathStr);
            try {
                fs = gcsPath.getFileSystem(configuration);
            }
            catch (IOException e) {
                LOG.info("Failed deleting file " + gcsPathStr + ", " + e.getMessage());
                continue;
            }
            Page blobs = storage.list(GCSPath.from(gcsPathStr).getBucket(), new Storage.BlobListOption[0]);
            for (Blob blob : blobs.iterateAll()) {
                Path filePath = new Path("gs://" + blob.getBucket() + "/" + blob.getName());
                if (!(filePath.toString() + "/").matches(regex)) continue;
                if (fs.exists(filePath)) {
                    Path rootPath = this.getRootMatch(filePath, regex);
                    try {
                        fs.delete(rootPath, true);
                        ++deleteCount;
                    }
                    catch (IOException e) {
                        LOG.warn(String.format("Failed to delete path '%s'", gcsPathStr));
                    }
                    continue;
                }
                ++deleteCount;
            }
        }
        context.getMetrics().gauge("gc.file.delete.count", (long)deleteCount);
    }

    public Path getRootMatch(Path filePath, String regx) {
        Path current = filePath;
        while (current.getParent() != null && (current.getParent().toString() + "/").matches(regx)) {
            current = current.getParent();
        }
        return current;
    }

    public static final class Config
    extends GCPConfig {
        public static final String NAME_PATHS = "paths";
        @Name(value="paths")
        @Description(value="Comma separated list of objects to be deleted. Valid formats: exact object and wildcard character (*).")
        @Macro
        private String paths;

        public List<String> getPaths() {
            return Arrays.stream(this.paths.split(",")).map(String::trim).collect(Collectors.toList());
        }

        void validate(FailureCollector collector) {
            if (!this.containsMacro(NAME_PATHS)) {
                for (String path : this.getPaths()) {
                    try {
                        GCSPath.from(path);
                    }
                    catch (IllegalArgumentException e) {
                        collector.addFailure(e.getMessage(), null).withConfigElement(NAME_PATHS, path);
                    }
                }
                collector.getOrThrowException();
            }
        }
    }
}

