/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.gcs.actions;

import com.google.cloud.kms.v1.CryptoKeyName;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.action.Action;
import io.cdap.cdap.etl.api.action.ActionContext;
import io.cdap.plugin.gcp.common.CmekUtils;
import io.cdap.plugin.gcp.gcs.GCSPath;
import io.cdap.plugin.gcp.gcs.StorageClient;
import io.cdap.plugin.gcp.gcs.actions.SourceDestConfig;
import java.io.IOException;
import javax.annotation.Nullable;

@Plugin(type="action")
@Name(value="GCSCopy")
@Description(value="Copies objects in Google Cloud Storage.")
public class GCSCopy
extends Action {
    public static final String NAME = "GCSCopy";
    private Config config;

    public void configurePipeline(PipelineConfigurer pipelineConfigurer) {
        this.config.validate(pipelineConfigurer.getStageConfigurer().getFailureCollector());
    }

    public void run(ActionContext context) throws IOException {
        FailureCollector collector = context.getFailureCollector();
        this.config.validate(collector, context.getArguments().asMap());
        Boolean isServiceAccountFilePath = this.config.isServiceAccountFilePath();
        if (isServiceAccountFilePath == null) {
            collector.addFailure("Service account type is undefined.", "Must be `filePath` or `JSON`");
            collector.getOrThrowException();
            return;
        }
        StorageClient storageClient = StorageClient.create(this.config.getProject(), this.config.getServiceAccount(), isServiceAccountFilePath);
        GCSPath destPath = this.config.getDestPath();
        CryptoKeyName cmekKeyName = CmekUtils.getCmekKey(this.config.cmekKey, context.getArguments().asMap(), collector);
        collector.getOrThrowException();
        storageClient.createBucketIfNotExists(destPath, this.config.location, cmekKeyName);
        storageClient.copy(this.config.getSourcePath(), this.config.getDestPath(), this.config.recursive, this.config.shouldOverwrite());
    }

    public static class Config
    extends SourceDestConfig {
        @Macro
        @Nullable
        @Description(value="Whether to copy objects in all subdirectories.")
        private Boolean recursive = false;
    }
}

