/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.gcs.actions;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.kms.v1.CryptoKeyName;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.common.base.Strings;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.etl.api.Arguments;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.batch.BatchActionContext;
import io.cdap.cdap.etl.api.batch.PostAction;
import io.cdap.plugin.common.batch.action.Condition;
import io.cdap.plugin.common.batch.action.ConditionConfig;
import io.cdap.plugin.gcp.common.CmekUtils;
import io.cdap.plugin.gcp.common.GCPConfig;
import io.cdap.plugin.gcp.common.GCPUtils;
import io.cdap.plugin.gcp.gcs.GCSPath;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(type="postaction")
@Name(value="GCSDoneFileMarker")
@Description(value="Creates a marker file with a given name in case of a succeeded, failed or completed pipeline.")
public class GCSDoneFileMarker
extends PostAction {
    private static final Logger LOG = LoggerFactory.getLogger(GCSDoneFileMarker.class);
    public static final String NAME = "GCSDoneFileMarker";
    public Config config;

    public void configurePipeline(PipelineConfigurer pipelineConfigurer) {
        this.config.validate(pipelineConfigurer.getStageConfigurer().getFailureCollector());
    }

    public void run(BatchActionContext batchActionContext) throws IOException {
        FailureCollector collector = batchActionContext.getFailureCollector();
        Map<String, String> runtimeArgs = this.getArgumentsAsMap(batchActionContext.getArguments());
        this.config.validate(collector, runtimeArgs);
        Boolean isServiceAccountFilePath = this.config.isServiceAccountFilePath();
        if (isServiceAccountFilePath == null) {
            collector.addFailure("Service account type is undefined.", "Must be `filePath` or `JSON`.");
            collector.getOrThrowException();
            return;
        }
        if (!this.config.shouldRun(batchActionContext)) {
            LOG.debug("GCS done maker action is not run. No new marker file will be created.");
            return;
        }
        GCSPath markerFilePath = GCSPath.from(this.config.path);
        String serviceAccount = this.config.getServiceAccount();
        CryptoKeyName cmekKeyName = CmekUtils.getCmekKey(this.config.cmekKey, runtimeArgs, collector);
        collector.getOrThrowException();
        GCSDoneFileMarker.createFileMarker(this.config.getProject(), markerFilePath, serviceAccount, this.config.isServiceAccountFilePath(), cmekKeyName, this.config.location);
    }

    public Map<String, String> getArgumentsAsMap(Arguments arguments) {
        HashMap<String, String> convertedArguments = new HashMap<String, String>(Collections.emptyMap());
        for (Map.Entry stringStringEntry : arguments) {
            convertedArguments.put((String)stringStringEntry.getKey(), (String)stringStringEntry.getValue());
        }
        return convertedArguments;
    }

    private static void createFileMarker(String project, GCSPath path, String serviceAccount, Boolean isServiceAccountFilePath, CryptoKeyName cmekKeyName, @Nullable String location) {
        Storage storage;
        GoogleCredentials credentials = null;
        if (serviceAccount != null) {
            try {
                credentials = GCPUtils.loadServiceAccountCredentials(serviceAccount, isServiceAccountFilePath);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Failed to load credentials from path %s: %s.", serviceAccount, e.getMessage()), e);
            }
        }
        if ((storage = GCPUtils.getStorage(project, credentials)).get(path.getBucket(), new Storage.BucketGetOption[0]) == null) {
            try {
                GCPUtils.createBucket(storage, path.getBucket(), location, cmekKeyName);
            }
            catch (StorageException e) {
                throw new RuntimeException(String.format("Failed to create bucket %s: %s.", path.getBucket(), e.getMessage()), e);
            }
        }
        BlobId markerFileId = BlobId.of((String)path.getBucket(), (String)path.getName());
        BlobInfo markerFileInfo = BlobInfo.newBuilder((BlobId)markerFileId).build();
        try {
            storage.create(markerFileInfo, "".getBytes(StandardCharsets.UTF_8), new Storage.BlobTargetOption[0]);
        }
        catch (StorageException e) {
            throw new RuntimeException(String.format("Failed to create the marker file at %s: %s.", path.getUri(), e.getMessage()), e);
        }
    }

    public static class Config
    extends GCPConfig {
        public static final String NAME_PATH = "path";
        public static final String NAME_RUN_CONDITION = "runCondition";
        public static final String NAME_LOCATION = "location";
        @Name(value="runCondition")
        @Description(value="When to run the action. Must be 'completion', 'success', or 'failure'. Defaults to 'completion'. If set to 'completion', the action will be executed and a marker file will get created regardless of whether the pipeline run succeeded or failed. If set to 'success', the action will get executed and the marker file will get created only if the pipeline run succeeded. If set to 'failure', the action will get executed and the marker file will get created only if the pipeline run failed")
        public String runCondition;
        @Name(value="path")
        @Description(value="GCS path where the marker file will get created.")
        @Macro
        public String path;
        @Name(value="location")
        @Macro
        @Nullable
        @Description(value="The location where the GCS bucket will get created. This value is ignored if the bucket already exists.")
        private String location;
        @Name(value="cmekKey")
        @Macro
        @Nullable
        @Description(value="The GCP customer managed encryption key (CMEK) name used to encrypt data written to any bucket created by the plugin. If the bucket already exists, this is ignored. More information can be found at https://cloud.google.com/data-fusion/docs/how-to/customer-managed-encryption-keys")
        protected String cmekKey;

        Config() {
            this.runCondition = Condition.SUCCESS.name();
        }

        private Config(String project, String serviceAccountType, @Nullable String serviceFilePath, @Nullable String serviceAccountJson, String gcsPath, @Nullable String location, @Nullable String cmekKey, String runCondition) {
            this.serviceAccountType = serviceAccountType;
            this.serviceAccountJson = serviceAccountJson;
            this.serviceFilePath = serviceFilePath;
            this.project = project;
            this.path = gcsPath;
            this.cmekKey = cmekKey;
            this.runCondition = runCondition;
            this.location = location;
        }

        void validate(FailureCollector collector) {
            this.validate(collector, Collections.emptyMap());
        }

        void validate(FailureCollector collector, Map<String, String> arguments) {
            Boolean isServiceAccountJson;
            Boolean isServiceAccountFilePath;
            if (!this.containsMacro(NAME_RUN_CONDITION)) {
                new ConditionConfig(this.runCondition).validate(collector);
            }
            if (!this.containsMacro(NAME_PATH)) {
                try {
                    GCSPath.from(this.path);
                }
                catch (IllegalArgumentException e) {
                    collector.addFailure(e.getMessage(), "Please provide a valid GCS path.").withConfigProperty(NAME_PATH);
                }
            }
            if ((isServiceAccountFilePath = this.isServiceAccountFilePath()) != null && isServiceAccountFilePath.booleanValue() && !this.containsMacro("serviceFilePath") && Strings.isNullOrEmpty((String)this.getServiceAccountFilePath()) && !"auto-detect".equals(this.serviceFilePath)) {
                collector.addFailure("Required property 'Service Account File Path' has no value.", "").withConfigProperty("serviceFilePath");
            }
            if ((isServiceAccountJson = this.isServiceAccountJson()) != null && isServiceAccountJson.booleanValue() && !this.containsMacro("serviceAccountJSON") && Strings.isNullOrEmpty((String)this.serviceAccountJson)) {
                collector.addFailure("Required property 'Service Account JSON' has no value.", "").withConfigProperty("serviceAccountJSON");
            }
            if (!this.containsMacro("cmekKey")) {
                this.validateCmekKey(collector, arguments);
            }
            collector.getOrThrowException();
        }

        void validateCmekKey(FailureCollector collector, Map<String, String> arguments) {
            CryptoKeyName cmekKeyName = CmekUtils.getCmekKey(this.cmekKey, arguments, collector);
            if (cmekKeyName == null || this.containsMacro(NAME_PATH) || this.containsMacro(NAME_LOCATION) || this.projectOrServiceAccountContainsMacro()) {
                return;
            }
            Storage storage = GCPUtils.getStorage(this.getProject(), this.getCredentials(collector));
            if (storage == null) {
                return;
            }
            CmekUtils.validateCmekKeyAndBucketLocation(storage, GCSPath.from(this.path), cmekKeyName, this.location, collector);
        }

        public boolean shouldRun(BatchActionContext actionContext) {
            return new ConditionConfig(this.runCondition).shouldRun(actionContext);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String serviceAccountType;
            private String serviceFilePath;
            private String serviceAccountJson;
            private String project;
            private String gcsPath;
            private String cmekKey;
            private String runCondition;
            private String location;

            public Builder setProject(@Nullable String project) {
                this.project = project;
                return this;
            }

            public Builder setServiceAccountType(@Nullable String serviceAccountType) {
                this.serviceAccountType = serviceAccountType;
                return this;
            }

            public Builder setServiceFilePath(@Nullable String serviceFilePath) {
                this.serviceFilePath = serviceFilePath;
                return this;
            }

            public Builder setServiceAccountJson(@Nullable String serviceAccountJson) {
                this.serviceAccountJson = serviceAccountJson;
                return this;
            }

            public Builder setGcsPath(@Nullable String gcsPath) {
                this.gcsPath = gcsPath;
                return this;
            }

            public Builder setLocation(String location) {
                this.location = location;
                return this;
            }

            public Builder setCmekKey(@Nullable String cmekKey) {
                this.cmekKey = cmekKey;
                return this;
            }

            public Builder setRunCondition(String runCondition) {
                this.runCondition = runCondition;
                return this;
            }

            public Config build() {
                return new Config(this.project, this.serviceAccountType, this.serviceFilePath, this.serviceAccountJson, this.gcsPath, this.location, this.cmekKey, this.runCondition);
            }
        }
    }
}

