/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.gcs.actions;

import com.google.cloud.kms.v1.CryptoKeyName;
import com.google.cloud.storage.Storage;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.gcp.common.CmekUtils;
import io.cdap.plugin.gcp.common.GCPConfig;
import io.cdap.plugin.gcp.common.GCPUtils;
import io.cdap.plugin.gcp.gcs.GCSPath;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

public class SourceDestConfig
extends GCPConfig {
    public static final String NAME_SOURCE_PATH = "sourcePath";
    public static final String NAME_DEST_PATH = "destPath";
    public static final String NAME_LOCATION = "location";
    @Name(value="sourcePath")
    @Macro
    @Description(value="Path to a source object or directory.")
    private String sourcePath;
    @Name(value="destPath")
    @Macro
    @Description(value="Path to the destination. The bucket will be created if it does not exist.")
    private String destPath;
    @Macro
    @Nullable
    @Description(value="Whether to overwrite existing objects.")
    private Boolean overwrite;
    @Name(value="location")
    @Macro
    @Nullable
    @Description(value="The location where the GCS bucket will get created. This value is ignored if the bucket already exists.")
    protected String location;
    @Name(value="cmekKey")
    @Macro
    @Nullable
    @Description(value="The GCP customer managed encryption key (CMEK) name used to encrypt data written to any bucket created by the plugin. If the bucket already exists, this is ignored. More information can be found at https://cloud.google.com/data-fusion/docs/how-to/customer-managed-encryption-keys")
    protected String cmekKey;

    public SourceDestConfig(@Nullable String project, @Nullable String serviceAccountType, @Nullable String serviceFilePath, @Nullable String serviceAccountJson, @Nullable String destPath, @Nullable String location, @Nullable String cmekKey) {
        this.serviceAccountType = serviceAccountType;
        this.serviceAccountJson = serviceAccountJson;
        this.serviceFilePath = serviceFilePath;
        this.project = project;
        this.destPath = destPath;
        this.location = location;
        this.cmekKey = cmekKey;
    }

    public SourceDestConfig() {
        this.overwrite = false;
    }

    GCSPath getSourcePath() {
        return GCSPath.from(this.sourcePath);
    }

    GCSPath getDestPath() {
        return GCSPath.from(this.destPath);
    }

    @Nullable
    Boolean shouldOverwrite() {
        return this.overwrite;
    }

    public void validate(FailureCollector collector) {
        this.validate(collector, Collections.emptyMap());
    }

    public void validate(FailureCollector collector, Map<String, String> arguments) {
        if (!this.containsMacro(NAME_SOURCE_PATH)) {
            try {
                this.getSourcePath();
            }
            catch (IllegalArgumentException e) {
                collector.addFailure(e.getMessage(), null).withConfigProperty(NAME_SOURCE_PATH);
            }
        }
        if (!this.containsMacro(NAME_DEST_PATH)) {
            try {
                this.getDestPath();
            }
            catch (IllegalArgumentException e) {
                collector.addFailure(e.getMessage(), null).withConfigProperty(NAME_DEST_PATH);
            }
        }
        if (!this.containsMacro("cmekKey")) {
            this.validateCmekKey(collector, arguments);
        }
        collector.getOrThrowException();
    }

    void validateCmekKey(FailureCollector failureCollector, Map<String, String> arguments) {
        CryptoKeyName cmekKeyName = CmekUtils.getCmekKey(this.cmekKey, arguments, failureCollector);
        if (cmekKeyName == null || this.containsMacro(NAME_DEST_PATH) || this.containsMacro(NAME_LOCATION) || this.projectOrServiceAccountContainsMacro()) {
            return;
        }
        Storage storage = GCPUtils.getStorage(this.getProject(), this.getCredentials(failureCollector));
        if (storage == null) {
            return;
        }
        CmekUtils.validateCmekKeyAndBucketLocation(storage, GCSPath.from(this.destPath), cmekKeyName, this.location, failureCollector);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String serviceAccountType;
        private String serviceFilePath;
        private String serviceAccountJson;
        private String project;
        private String destPath;
        private String cmekKey;
        private String location;

        public Builder setProject(@Nullable String project) {
            this.project = project;
            return this;
        }

        public Builder setServiceAccountType(@Nullable String serviceAccountType) {
            this.serviceAccountType = serviceAccountType;
            return this;
        }

        public Builder setServiceFilePath(@Nullable String serviceFilePath) {
            this.serviceFilePath = serviceFilePath;
            return this;
        }

        public Builder setServiceAccountJson(@Nullable String serviceAccountJson) {
            this.serviceAccountJson = serviceAccountJson;
            return this;
        }

        public Builder setGcsPath(@Nullable String destPath) {
            this.destPath = destPath;
            return this;
        }

        public Builder setCmekKey(@Nullable String cmekKey) {
            this.cmekKey = cmekKey;
            return this;
        }

        public Builder setLocation(@Nullable String location) {
            this.location = location;
            return this;
        }

        public SourceDestConfig build() {
            return new SourceDestConfig(this.project, this.serviceAccountType, this.serviceFilePath, this.serviceAccountJson, this.destPath, this.location, this.cmekKey);
        }
    }
}

