/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.gcs.connector;

import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import io.cdap.cdap.api.annotation.Category;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.connector.BrowseDetail;
import io.cdap.cdap.etl.api.connector.BrowseEntity;
import io.cdap.cdap.etl.api.connector.BrowseEntityPropertyValue;
import io.cdap.cdap.etl.api.connector.BrowseRequest;
import io.cdap.cdap.etl.api.connector.ConnectorContext;
import io.cdap.cdap.etl.api.connector.ConnectorSpec;
import io.cdap.cdap.etl.api.connector.ConnectorSpecRequest;
import io.cdap.cdap.etl.api.connector.PluginSpec;
import io.cdap.cdap.etl.api.validation.ValidationException;
import io.cdap.plugin.common.ReferenceNames;
import io.cdap.plugin.format.connector.AbstractFileConnector;
import io.cdap.plugin.format.connector.FileTypeDetector;
import io.cdap.plugin.gcp.common.GCPConnectorConfig;
import io.cdap.plugin.gcp.common.GCPUtils;
import io.cdap.plugin.gcp.gcs.GCSPath;
import io.cdap.plugin.gcp.gcs.connector.GCSConnectorConfig;
import io.cdap.plugin.gcp.gcs.source.GCSSource;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Plugin(type="connector")
@Name(value="GCS")
@Category(value="Google Cloud Platform")
@Description(value="Connection to access data in Google Cloud Storage.")
public class GCSConnector
extends AbstractFileConnector<GCPConnectorConfig> {
    public static final String NAME = "GCS";
    static final String BUCKET_TYPE = "bucket";
    static final String DIRECTORY_TYPE = "directory";
    static final String FILE_TYPE = "file";
    static final String LAST_MODIFIED_KEY = "Last Modified";
    static final String SIZE_KEY = "Size";
    static final String FILE_TYPE_KEY = "File Type";
    private final GCSConnectorConfig config;

    public GCSConnector(GCSConnectorConfig config) {
        super((PluginConfig)config);
        this.config = config;
        Map<String, String> additionalProperties = Collections.singletonMap("_pluginName", "GCSFile");
        this.initSampleFields(FILE_TYPE, GCSSource.GCSSourceConfig.class, additionalProperties);
    }

    public void test(ConnectorContext context) throws ValidationException {
        Boolean isServiceAccountFilePath;
        String project = this.config.tryGetProject();
        FailureCollector failureCollector = context.getFailureCollector();
        if (project == null) {
            failureCollector.addFailure("Could not detect Google Cloud project id from the environment.", "Please specify a project id.").withConfigProperty("project");
        }
        if ((isServiceAccountFilePath = this.config.isServiceAccountFilePath()) == null) {
            failureCollector.addFailure("Service account type is undefined.", "Must be `filePath` or `JSON`");
        }
        if (!failureCollector.getValidationFailures().isEmpty()) {
            return;
        }
        GoogleCredentials credentials = null;
        try {
            credentials = this.config.getServiceAccount() == null ? null : GCPUtils.loadServiceAccountCredentials(this.config.getServiceAccount(), this.config.isServiceAccountFilePath());
        }
        catch (IOException | IllegalArgumentException e) {
            failureCollector.addFailure(String.format("Service account provided is not valid: %s.", e.getMessage()), "Please provide a valid service account key.").withStacktrace(e.getStackTrace());
        }
        try {
            Storage storage = GCPUtils.getStorage(project, credentials);
            storage.list(new Storage.BucketListOption[]{Storage.BucketListOption.pageSize((long)1L)});
        }
        catch (Exception e) {
            failureCollector.addFailure(String.format("Not able to connect to GCS. Error: %s", e.getMessage()), "Please provide valid configs to connect to GCS").withStacktrace(e.getStackTrace());
        }
    }

    public BrowseDetail browse(ConnectorContext connectorContext, BrowseRequest request) throws IOException {
        int limit;
        String path = request.getPath();
        int n = limit = request.getLimit() == null || request.getLimit() <= 0 ? Integer.MAX_VALUE : request.getLimit();
        if (this.isRoot(path)) {
            return this.config.rootBucket == null ? this.browseBuckets(limit) : BrowseDetail.builder().setTotalCount(1).addEntity(BrowseEntity.builder((String)this.config.rootBucket, (String)this.config.rootBucket, (String)BUCKET_TYPE).canBrowse(true).canSample(true).build()).build();
        }
        return this.browseBlobs(GCSPath.from(path), limit);
    }

    protected String getFullPath(String path) {
        if (this.isRoot(path)) {
            return "gs://";
        }
        GCSPath gcsPath = GCSPath.from(path);
        return "gs://" + gcsPath.getBucket() + gcsPath.getUri().getPath();
    }

    protected Map<String, String> getFileSystemProperties(String path) {
        return GCPUtils.getFileSystemProperties(this.config, path, new HashMap<String, String>());
    }

    protected void setConnectorSpec(ConnectorSpecRequest request, ConnectorSpec.Builder builder) {
        super.setConnectorSpec(request, builder);
        HashMap<String, String> sourceProperties = new HashMap<String, String>(this.getAdditionalSpecProperties(request));
        HashMap<String, String> sinkProperties = new HashMap<String, String>();
        String path = request.getPath();
        String fullPath = this.getFullPath(path);
        if (!sourceProperties.containsKey("format")) {
            sourceProperties.put("format", FileTypeDetector.detectFileFormat((String)FileTypeDetector.detectFileType((String)path)).name().toLowerCase());
        }
        sourceProperties.put("path", fullPath);
        sinkProperties.put("path", fullPath);
        sourceProperties.put("useConnection", "true");
        sinkProperties.put("useConnection", "true");
        sourceProperties.put("connection", request.getConnectionWithMacro());
        sinkProperties.put("connection", request.getConnectionWithMacro());
        if (!this.isRoot(path)) {
            GCSPath gcsPath = GCSPath.from(path);
            String referenceName = ReferenceNames.cleanseReferenceName((String)(gcsPath.getBucket() + "." + gcsPath.getName()));
            sourceProperties.put("referenceName", referenceName);
        }
        builder.addRelatedPlugin(new PluginSpec("GCSFile", "batchsource", sourceProperties));
        builder.addRelatedPlugin(new PluginSpec(NAME, "batchsink", sinkProperties));
        builder.addRelatedPlugin(new PluginSpec("GCSMultiFiles", "batchsink", sinkProperties));
    }

    private BrowseDetail browseBuckets(int limit) throws IOException {
        Storage storage = this.getStorage();
        Page buckets = storage.list(new Storage.BucketListOption[0]);
        int count = 0;
        BrowseDetail.Builder builder = BrowseDetail.builder();
        for (Bucket bucket : buckets.iterateAll()) {
            if (count >= limit) break;
            String name = bucket.getName();
            builder.addEntity(BrowseEntity.builder((String)name, (String)name, (String)BUCKET_TYPE).canBrowse(true).canSample(true).build());
            ++count;
        }
        return builder.setTotalCount(count).build();
    }

    private BrowseDetail browseBlobs(GCSPath path, int limit) throws IOException {
        Storage storage = this.getStorage();
        String pathBlobName = path.getName();
        Page blobs = storage.list(path.getBucket(), new Storage.BlobListOption[]{Storage.BlobListOption.currentDirectory(), Storage.BlobListOption.prefix((String)pathBlobName)});
        int count = 0;
        BrowseDetail.Builder builder = BrowseDetail.builder();
        BrowseEntity entityForPath = null;
        for (Blob blob : blobs.iterateAll()) {
            String blobName = blob.getName();
            if (count >= limit) break;
            boolean directory = blobName.equals(pathBlobName) ? pathBlobName.endsWith("/") : blob.isDirectory();
            BrowseEntity.Builder entity = BrowseEntity.builder((String)new File(blobName).getName(), (String)String.format("%s/%s", blob.getBucket(), blobName), (String)(directory ? DIRECTORY_TYPE : FILE_TYPE)).canBrowse(directory).canSample(directory);
            if (!directory) {
                entity.addProperty(SIZE_KEY, BrowseEntityPropertyValue.builder((String)String.valueOf(blob.getSize()), (BrowseEntityPropertyValue.PropertyType)BrowseEntityPropertyValue.PropertyType.SIZE_BYTES).build());
                entity.addProperty(LAST_MODIFIED_KEY, BrowseEntityPropertyValue.builder((String)String.valueOf(blob.getUpdateTime()), (BrowseEntityPropertyValue.PropertyType)BrowseEntityPropertyValue.PropertyType.TIMESTAMP_MILLIS).build());
                String fileType = FileTypeDetector.detectFileType((String)blobName);
                entity.addProperty(FILE_TYPE_KEY, BrowseEntityPropertyValue.builder((String)fileType, (BrowseEntityPropertyValue.PropertyType)BrowseEntityPropertyValue.PropertyType.STRING).build());
                this.addBrowseSampleDefaultValues(entity, blobName);
                entity.canSample(FileTypeDetector.isSampleable((String)fileType));
            }
            if (blobName.equals(pathBlobName)) {
                entityForPath = entity.build();
                continue;
            }
            ++count;
            builder.addEntity(entity.build());
        }
        builder.setSampleProperties((Collection)this.getSampleProperties());
        if (entityForPath != null && count == 0 && entityForPath.getType().equals(FILE_TYPE)) {
            return builder.setTotalCount(1).addEntity(entityForPath).build();
        }
        return builder.setTotalCount(count).build();
    }

    private Storage getStorage() throws IOException {
        Boolean serviceAccountFilePath = this.config.isServiceAccountFilePath();
        if (serviceAccountFilePath == null) {
            throw new IllegalArgumentException("Service account type is undefined. Must be `filePath` or `JSON`");
        }
        GoogleCredentials credentials = this.config.getServiceAccount() == null ? null : GCPUtils.loadServiceAccountCredentials(this.config.getServiceAccount(), serviceAccountFilePath);
        return GCPUtils.getStorage(this.config.getProject(), (Credentials)credentials);
    }

    private boolean isRoot(String path) {
        return path.isEmpty() || path.equals("/");
    }
}

