/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.gcs.sink;

import io.cdap.plugin.gcp.gcs.sink.DelegatingGCSOutputUtils;
import io.cdap.plugin.gcp.gcs.sink.GCSOutputCommitter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class DelegatingGCSOutputCommitter
extends OutputCommitter {
    private final Map<String, OutputCommitter> committerMap = new HashMap<String, OutputCommitter>();

    public void addGCSOutputCommitterFromOutputFormat(OutputFormat outputFormat, TaskAttemptContext context, String tableName) throws IOException, InterruptedException {
        context.getConfiguration().set("mapreduce.output.fileoutputformat.outputdir", DelegatingGCSOutputUtils.buildOutputPath(context.getConfiguration(), tableName));
        GCSOutputCommitter gcsOutputCommitter = new GCSOutputCommitter(outputFormat.getOutputCommitter(context));
        gcsOutputCommitter.setupJob((JobContext)context);
        gcsOutputCommitter.setupTask(context);
        this.committerMap.put(tableName, gcsOutputCommitter);
    }

    public void setupJob(JobContext jobContext) throws IOException {
    }

    public void setupTask(TaskAttemptContext taskAttemptContext) throws IOException {
    }

    public boolean needsTaskCommit(TaskAttemptContext taskAttemptContext) throws IOException {
        if (this.committerMap.isEmpty()) {
            return false;
        }
        boolean needsTaskCommit = true;
        for (OutputCommitter committer : this.committerMap.values()) {
            needsTaskCommit = needsTaskCommit && committer.needsTaskCommit(taskAttemptContext);
        }
        return needsTaskCommit;
    }

    public void commitTask(TaskAttemptContext taskAttemptContext) throws IOException {
        for (OutputCommitter committer : this.committerMap.values()) {
            committer.commitTask(taskAttemptContext);
        }
    }

    public void commitJob(JobContext jobContext) throws IOException {
        for (OutputCommitter committer : this.committerMap.values()) {
            committer.commitJob(jobContext);
        }
    }

    public void abortTask(TaskAttemptContext taskAttemptContext) throws IOException {
        IOException ioe = null;
        for (OutputCommitter committer : this.committerMap.values()) {
            try {
                committer.abortTask(taskAttemptContext);
            }
            catch (IOException e) {
                if (ioe == null) {
                    ioe = e;
                    continue;
                }
                ioe.addSuppressed(e);
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public void abortJob(JobContext jobContext, JobStatus.State state) throws IOException {
        IOException ioe = null;
        for (OutputCommitter committer : this.committerMap.values()) {
            try {
                committer.abortJob(jobContext, state);
            }
            catch (IOException e) {
                if (ioe == null) {
                    ioe = e;
                    continue;
                }
                ioe.addSuppressed(e);
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }
}

