/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.gcs.sink;

import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.plugin.gcp.gcs.sink.DelegatingGCSOutputCommitter;
import io.cdap.plugin.gcp.gcs.sink.DelegatingGCSRecordWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class DelegatingGCSOutputFormat
extends OutputFormat<NullWritable, StructuredRecord> {
    public static final String PARTITION_FIELD = "delegating_output_format.partition.field";
    public static final String DELEGATE_CLASS = "delegating_output_format.delegate";
    public static final String OUTPUT_PATH_BASE_DIR = "delegating_output_format.output.path.base";
    public static final String OUTPUT_PATH_SUFFIX = "delegating_output_format.output.path.suffix";
    private final DelegatingGCSOutputCommitter outputCommitter = new DelegatingGCSOutputCommitter();

    public static Map<String, String> configure(String delegateClassName, String filterField, String outputBaseDir, String outputSuffix) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(DELEGATE_CLASS, delegateClassName);
        config.put(PARTITION_FIELD, filterField);
        config.put(OUTPUT_PATH_BASE_DIR, outputBaseDir);
        config.put(OUTPUT_PATH_SUFFIX, outputSuffix);
        return config;
    }

    public RecordWriter<NullWritable, StructuredRecord> getRecordWriter(TaskAttemptContext context) {
        Configuration hConf = context.getConfiguration();
        String partitionField = hConf.get(PARTITION_FIELD);
        return new DelegatingGCSRecordWriter(context, partitionField, this.outputCommitter);
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return this.outputCommitter;
    }
}

