/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.gcs.sink;

import io.cdap.cdap.api.data.format.StructuredRecord;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.OutputFormat;

public class DelegatingGCSOutputUtils {
    public static OutputFormat<NullWritable, StructuredRecord> getDelegateFormat(Configuration hConf) throws IOException {
        String delegateClassName = hConf.get("delegating_output_format.delegate");
        try {
            Class delegateClass = hConf.getClassByName(delegateClassName);
            return (OutputFormat)delegateClass.newInstance();
        }
        catch (Exception e) {
            throw new IOException("Unable to instantiate output format for class " + delegateClassName, e);
        }
    }

    public static String buildOutputPath(Configuration hConf, String context) {
        return String.format("%s/%s/%s", hConf.get("delegating_output_format.output.path.base"), context, hConf.get("delegating_output_format.output.path.suffix"));
    }
}

