/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.gcs.sink;

import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.plugin.gcp.gcs.sink.DelegatingGCSOutputCommitter;
import io.cdap.plugin.gcp.gcs.sink.DelegatingGCSOutputUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingGCSRecordWriter
extends RecordWriter<NullWritable, StructuredRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(DelegatingGCSRecordWriter.class);
    private final TaskAttemptContext context;
    private final String partitionField;
    private final Map<String, RecordWriter<NullWritable, StructuredRecord>> delegateMap;
    private final DelegatingGCSOutputCommitter delegatingGCSOutputCommitter;

    DelegatingGCSRecordWriter(TaskAttemptContext context, String partitionField, DelegatingGCSOutputCommitter delegatingGCSOutputCommitter) {
        this.context = context;
        this.partitionField = partitionField;
        this.delegateMap = new HashMap<String, RecordWriter<NullWritable, StructuredRecord>>();
        this.delegatingGCSOutputCommitter = delegatingGCSOutputCommitter;
    }

    public void write(NullWritable key, StructuredRecord record) throws IOException, InterruptedException {
        RecordWriter delegate;
        String tableName = (String)record.get(this.partitionField);
        if (this.delegateMap.containsKey(tableName)) {
            delegate = this.delegateMap.get(tableName);
        } else {
            OutputFormat<NullWritable, StructuredRecord> format = DelegatingGCSOutputUtils.getDelegateFormat(this.context.getConfiguration());
            this.delegatingGCSOutputCommitter.addGCSOutputCommitterFromOutputFormat(format, this.context, tableName);
            delegate = format.getRecordWriter(this.context);
            this.delegateMap.put(tableName, (RecordWriter<NullWritable, StructuredRecord>)delegate);
        }
        delegate.write((Object)key, (Object)record);
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        for (RecordWriter<NullWritable, StructuredRecord> delegate : this.delegateMap.values()) {
            delegate.close(context);
        }
        this.delegatingGCSOutputCommitter.commitTask(context);
        this.delegatingGCSOutputCommitter.commitJob((JobContext)context);
    }
}

