/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.gcs.sink;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.common.annotations.VisibleForTesting;
import io.cdap.plugin.gcp.common.GCPUtils;
import io.cdap.plugin.gcp.gcs.StorageClient;
import io.cdap.plugin.gcp.gcs.sink.GCSOutputFormatProvider;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCSOutputCommitter
extends OutputCommitter {
    private static final Logger LOG = LoggerFactory.getLogger(GCSOutputFormatProvider.class);
    public static final String RECORD_COUNT_FORMAT = "recordcount.%s";
    private final OutputCommitter delegate;

    public GCSOutputCommitter(OutputCommitter delegate) {
        this.delegate = delegate;
    }

    public void setupJob(JobContext jobContext) throws IOException {
        this.delegate.setupJob(jobContext);
    }

    public void cleanupJob(JobContext jobContext) throws IOException {
        this.delegate.cleanupJob(jobContext);
    }

    public void commitJob(JobContext jobContext) throws IOException {
        this.delegate.commitJob(jobContext);
    }

    public void abortJob(JobContext jobContext, JobStatus.State state) throws IOException {
        this.delegate.abortJob(jobContext, state);
    }

    public void setupTask(TaskAttemptContext taskAttemptContext) throws IOException {
        this.delegate.setupTask(taskAttemptContext);
    }

    public boolean needsTaskCommit(TaskAttemptContext taskAttemptContext) throws IOException {
        return this.delegate.needsTaskCommit(taskAttemptContext);
    }

    public void commitTask(TaskAttemptContext taskAttemptContext) throws IOException {
        try {
            this.updateMetricMetaData(taskAttemptContext);
        }
        catch (Exception exception) {
            LOG.warn("Unable to record metric for task. Metric emitted for the number of affected rows may be incorrect.", (Throwable)exception);
        }
        this.delegate.commitTask(taskAttemptContext);
    }

    private void updateMetricMetaData(TaskAttemptContext taskAttemptContext) throws IOException {
        if (!(this.delegate instanceof FileOutputCommitter)) {
            return;
        }
        FileOutputCommitter fileOutputCommitter = (FileOutputCommitter)this.delegate;
        Configuration configuration = taskAttemptContext.getConfiguration();
        Path taskAttemptPath = fileOutputCommitter.getTaskAttemptPath(taskAttemptContext);
        if (configuration == null || taskAttemptPath == null) {
            return;
        }
        String keyInConfig = String.format(RECORD_COUNT_FORMAT, taskAttemptContext.getTaskAttemptID());
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("recordcount", String.valueOf(configuration.getLong(keyInConfig, 0L)));
        StorageClient storageClient = this.getStorageClient(configuration);
        Blob blob = storageClient.pickABlob(taskAttemptPath.toString());
        if (blob == null) {
            LOG.info("Could not find a file in path {} to apply count metadata.", (Object)taskAttemptPath.toString());
            return;
        }
        blob.toBuilder().setContentType(configuration.get("io.cdap.gcs.batch.sink.content.type")).setMetadata(metaData).build().update(new Storage.BlobTargetOption[0]);
    }

    @VisibleForTesting
    StorageClient getStorageClient(Configuration configuration) throws IOException {
        String project = configuration.get("fs.gs.project.id");
        GoogleCredentials credentials = GCPUtils.loadCredentialsFromConf(configuration);
        Storage storage = (Storage)((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(project)).setCredentials((Credentials)credentials)).build().getService();
        return new StorageClient(storage);
    }

    public void abortTask(TaskAttemptContext taskAttemptContext) throws IOException {
        this.delegate.abortTask(taskAttemptContext);
    }

    public boolean isCommitJobRepeatable(JobContext jobContext) throws IOException {
        return this.delegate.isCommitJobRepeatable(jobContext);
    }

    public boolean isRecoverySupported(JobContext jobContext) throws IOException {
        return this.delegate.isRecoverySupported(jobContext);
    }

    public boolean isRecoverySupported() {
        return this.delegate.isRecoverySupported();
    }

    public void recoverTask(TaskAttemptContext taskContext) throws IOException {
        this.delegate.recoverTask(taskContext);
    }
}

