/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.gcs.sink;

import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.etl.api.validation.FormatContext;
import io.cdap.cdap.etl.api.validation.ValidatingOutputFormat;
import io.cdap.plugin.gcp.gcs.sink.GCSOutputCommitter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.ReflectionUtils;

public class GCSOutputFormatProvider
implements ValidatingOutputFormat {
    public static final String DELEGATE_OUTPUTFORMAT_CLASSNAME = "gcssink.delegate.outputformat.classname";
    private static final String OUTPUT_FOLDER = "gcssink.metric.output.folder";
    public static final String RECORD_COUNT_FORMAT = "recordcount.%s";
    private final ValidatingOutputFormat delegate;

    public GCSOutputFormatProvider(ValidatingOutputFormat delegate) {
        this.delegate = delegate;
    }

    public void validate(FormatContext context) {
        this.delegate.validate(context);
    }

    public String getOutputFormatClassName() {
        return GCSOutputFormat.class.getName();
    }

    public Map<String, String> getOutputFormatConfiguration() {
        HashMap<String, String> outputFormatConfiguration = new HashMap<String, String>(this.delegate.getOutputFormatConfiguration());
        outputFormatConfiguration.put(DELEGATE_OUTPUTFORMAT_CLASSNAME, this.delegate.getOutputFormatClassName());
        return outputFormatConfiguration;
    }

    public static class GCSRecordWriter
    extends RecordWriter<NullWritable, StructuredRecord> {
        private final RecordWriter originalWriter;
        private long recordCount;

        public GCSRecordWriter(RecordWriter originalWriter) {
            this.originalWriter = originalWriter;
        }

        public void write(NullWritable nullWritable, StructuredRecord structuredRecord) throws IOException, InterruptedException {
            this.originalWriter.write((Object)nullWritable, (Object)structuredRecord);
            ++this.recordCount;
        }

        public void close(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            this.originalWriter.close(taskAttemptContext);
            taskAttemptContext.getConfiguration().setLong(String.format(GCSOutputFormatProvider.RECORD_COUNT_FORMAT, taskAttemptContext.getTaskAttemptID()), this.recordCount);
        }
    }

    public static class GCSOutputFormat
    extends OutputFormat<NullWritable, StructuredRecord> {
        private OutputFormat delegateFormat;

        private OutputFormat getDelegateFormatInstance(Configuration configuration) throws IOException {
            if (this.delegateFormat != null) {
                return this.delegateFormat;
            }
            String delegateClassName = configuration.get(GCSOutputFormatProvider.DELEGATE_OUTPUTFORMAT_CLASSNAME);
            try {
                this.delegateFormat = (OutputFormat)ReflectionUtils.newInstance((Class)configuration.getClassByName(delegateClassName), (Configuration)configuration);
                return this.delegateFormat;
            }
            catch (ClassNotFoundException e) {
                throw new IOException(String.format("Unable to instantiate output format for class %s", delegateClassName), e);
            }
        }

        public RecordWriter<NullWritable, StructuredRecord> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            RecordWriter originalWriter = this.getDelegateFormatInstance(taskAttemptContext.getConfiguration()).getRecordWriter(taskAttemptContext);
            return new GCSRecordWriter(originalWriter);
        }

        public void checkOutputSpecs(JobContext jobContext) throws IOException, InterruptedException {
            this.getDelegateFormatInstance(jobContext.getConfiguration()).checkOutputSpecs(jobContext);
        }

        public OutputCommitter getOutputCommitter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            OutputCommitter delegateCommitter = this.getDelegateFormatInstance(taskAttemptContext.getConfiguration()).getOutputCommitter(taskAttemptContext);
            return new GCSOutputCommitter(delegateCommitter);
        }
    }
}

