/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.gcs.sink;

import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.gcp.gcs.sink.GCSOutputCommitter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class RecordFilterOutputFormat
extends OutputFormat<NullWritable, StructuredRecord> {
    public static final String FILTER_FIELD = "record.filter.field";
    public static final String PASS_VALUE = "record.filter.val";
    public static final String ORIGINAL_SCHEMA = "record.original.schema";
    private static final String DELEGATE_CLASS = "filter.delegate";

    public static Map<String, String> configure(String delegateClassName, String filterField, String passThroughValue, Schema schema) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(DELEGATE_CLASS, delegateClassName);
        config.put(FILTER_FIELD, filterField);
        config.put(PASS_VALUE, passThroughValue);
        config.put(ORIGINAL_SCHEMA, schema.toString());
        return config;
    }

    public RecordWriter<NullWritable, StructuredRecord> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration hConf = context.getConfiguration();
        RecordWriter delegate = this.getDelegateFormat(hConf).getRecordWriter(context);
        String filterField = hConf.get(FILTER_FIELD);
        String passthroughVal = hConf.get(PASS_VALUE);
        Schema schema = Schema.parseJson((String)hConf.get(ORIGINAL_SCHEMA));
        return new FilterRecordWriter((RecordWriter<NullWritable, StructuredRecord>)delegate, filterField, passthroughVal, schema);
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        this.getDelegateFormat(context.getConfiguration()).checkOutputSpecs(context);
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        OutputCommitter outputCommitter = this.getDelegateFormat(context.getConfiguration()).getOutputCommitter(context);
        return new GCSOutputCommitter(outputCommitter);
    }

    private OutputFormat getDelegateFormat(Configuration hConf) throws IOException {
        String delegateClassName = hConf.get(DELEGATE_CLASS);
        try {
            Class delegateClass = hConf.getClassByName(delegateClassName);
            return (OutputFormat)delegateClass.newInstance();
        }
        catch (Exception e) {
            throw new IOException("Unable to instantiate output format for class " + delegateClassName, e);
        }
    }

    public static class FilterRecordWriter
    extends RecordWriter<NullWritable, StructuredRecord> {
        private final String filterField;
        private final String passthroughValue;
        private final RecordWriter<NullWritable, StructuredRecord> delegate;
        private final Schema schema;

        FilterRecordWriter(RecordWriter<NullWritable, StructuredRecord> delegate, String filterField, String passthroughValue, Schema schema) {
            this.filterField = filterField;
            this.passthroughValue = passthroughValue;
            this.delegate = delegate;
            this.schema = schema;
        }

        public void write(NullWritable key, StructuredRecord record) throws IOException, InterruptedException {
            String val = (String)record.get(this.filterField);
            if (!this.passthroughValue.equalsIgnoreCase(val)) {
                return;
            }
            StructuredRecord.Builder recordBuilder = StructuredRecord.builder((Schema)this.schema);
            for (Schema.Field field : record.getSchema().getFields()) {
                String fieldName = field.getName();
                if (this.filterField.equals(fieldName)) continue;
                recordBuilder.set(fieldName, record.get(fieldName));
            }
            this.delegate.write((Object)key, (Object)recordBuilder.build());
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.delegate.close(context);
        }
    }
}

