/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.gcs.source;

import io.cdap.plugin.format.RegexPathFilter;
import io.cdap.plugin.gcp.gcs.source.GCSSource;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class GCSRegexPathFilter
extends RegexPathFilter {
    private static final String EXCLUSION_REGEX = "path.filter.exclude.regex";
    private Pattern exclusionPattern;

    public static Map<String, String> configure(GCSSource.GCSSourceConfig sourceConfig, Map<String, String> properties) {
        Pattern pattern = sourceConfig.getExclusionPattern();
        if (pattern != null) {
            properties.put(EXCLUSION_REGEX, pattern.pattern());
            properties.put("mapreduce.input.pathFilter.class", GCSRegexPathFilter.class.getName());
        }
        return properties;
    }

    public boolean accept(Path path) {
        if (!super.accept(path)) {
            return false;
        }
        return this.exclusionPattern == null || !this.exclusionPattern.matcher(path.toUri().getPath()).matches();
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        String pattern = conf.getRaw(EXCLUSION_REGEX);
        if (pattern != null) {
            this.exclusionPattern = Pattern.compile(pattern);
        }
    }
}

