/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.gcs.source;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Metadata;
import io.cdap.cdap.api.annotation.MetadataProperty;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.batch.BatchContext;
import io.cdap.cdap.etl.api.batch.BatchSourceContext;
import io.cdap.plugin.common.Asset;
import io.cdap.plugin.common.ConfigUtil;
import io.cdap.plugin.common.LineageRecorder;
import io.cdap.plugin.common.ReferenceNames;
import io.cdap.plugin.format.plugin.AbstractFileSource;
import io.cdap.plugin.format.plugin.AbstractFileSourceConfig;
import io.cdap.plugin.format.plugin.FileSourceProperties;
import io.cdap.plugin.gcp.common.GCPConnectorConfig;
import io.cdap.plugin.gcp.common.GCPUtils;
import io.cdap.plugin.gcp.crypto.EncryptedFileSystem;
import io.cdap.plugin.gcp.gcs.GCSPath;
import io.cdap.plugin.gcp.gcs.source.GCSRegexPathFilter;
import io.cdap.plugin.gcp.gcs.source.TinkDecryptor;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@Plugin(type="batchsource")
@Name(value="GCSFile")
@Description(value="Reads objects from a path in a Google Cloud Storage bucket.")
@Metadata(properties={@MetadataProperty(key="connector", value="GCS")})
public class GCSSource
extends AbstractFileSource<GCSSourceConfig> {
    public static final String NAME = "GCSFile";
    private final GCSSourceConfig config;
    private Asset asset;

    public GCSSource(GCSSourceConfig config) {
        super((PluginConfig)config);
        this.config = config;
    }

    public void configurePipeline(PipelineConfigurer pipelineConfigurer) {
        super.configurePipeline(pipelineConfigurer);
    }

    public void prepareRun(BatchSourceContext context) throws Exception {
        String location;
        String bucketName = GCSPath.from(this.config.getPath()).getBucket();
        GoogleCredentials credentials = this.config.connection.getServiceAccount() == null ? null : GCPUtils.loadServiceAccountCredentials(this.config.connection.getServiceAccount(), this.config.connection.isServiceAccountFilePath());
        Storage storage = GCPUtils.getStorage(this.config.connection.getProject(), credentials);
        try {
            location = storage.get(bucketName, new Storage.BucketGetOption[0]).getLocation();
        }
        catch (StorageException e) {
            throw new RuntimeException(String.format("Unable to access bucket %s. ", bucketName) + "Ensure you entered the correct bucket path and have permissions for it.", e);
        }
        String referenceName = Strings.isNullOrEmpty((String)this.config.getReferenceName()) ? ReferenceNames.normalizeFqn((String)this.config.getPath()) : this.config.getReferenceName();
        this.asset = Asset.builder((String)referenceName).setFqn(this.config.getPath()).setLocation(location).build();
        super.prepareRun(context);
    }

    protected Map<String, String> getFileSystemProperties(BatchSourceContext context) {
        Map<String, String> properties = GCPUtils.getFileSystemProperties(this.config.connection, this.config.getPath(), new HashMap<String, String>(this.config.getFileSystemProperties()));
        if (this.config.isCopyHeader()) {
            properties.put("path.tracking.copy.header", Boolean.TRUE.toString());
        }
        if (this.config.getFileEncoding() != null && !this.config.getFileEncoding().equalsIgnoreCase("UTF-8")) {
            properties.put("path.tracking.encoding", this.config.getFileEncoding());
        }
        if (this.config.getMinSplitSize() != null) {
            properties.put("mapreduce.input.fileinputformat.split.minsize", String.valueOf(this.config.getMinSplitSize()));
        }
        if (this.config.isEncrypted()) {
            TinkDecryptor.configure(this.config.getEncryptedMetadataSuffix(), properties);
            EncryptedFileSystem.configure("gs", TinkDecryptor.class, properties);
            GCSRegexPathFilter.configure(this.config, properties);
        }
        return properties;
    }

    protected LineageRecorder getLineageRecorder(BatchSourceContext context) {
        return new LineageRecorder((BatchContext)context, this.asset);
    }

    protected void recordLineage(LineageRecorder lineageRecorder, List<String> outputFields) {
        lineageRecorder.recordRead("Read", String.format("Read%sfrom Google Cloud Storage.", this.config.isEncrypted() ? " and decrypt " : " "), outputFields);
    }

    protected boolean shouldGetSchema() {
        return !this.config.containsMacro("project") && !this.config.containsMacro("path") && !this.config.containsMacro("format") && !this.config.containsMacro("delimiter") && !this.config.containsMacro("fileSystemProperties") && !this.config.containsMacro("serviceFilePath") && !this.config.containsMacro("serviceAccountJSON");
    }

    public static class GCSSourceConfig
    extends AbstractFileSourceConfig
    implements FileSourceProperties {
        public static final String NAME_PATH = "path";
        public static final String NAME_FORMAT = "format";
        private static final String NAME_FILE_SYSTEM_PROPERTIES = "fileSystemProperties";
        private static final String NAME_FILE_REGEX = "fileRegex";
        private static final String NAME_DELIMITER = "delimiter";
        private static final String DEFAULT_ENCRYPTED_METADATA_SUFFIX = ".metadata";
        private static final Gson GSON = new Gson();
        private static final Type MAP_STRING_STRING_TYPE = new TypeToken<Map<String, String>>(){}.getType();
        @Macro
        @Description(value="The path to read from. For example, gs://<bucket>/path/to/directory/")
        private String path;
        @Macro
        @Nullable
        @Description(value="Map of properties to set on the InputFormat.")
        private String fileSystemProperties;
        @Macro
        @Nullable
        @Description(value="Minimum size of each partition used to read data. ")
        private Long minSplitSize;
        @Macro
        @Nullable
        @Description(value="Whether the data file is encrypted. If it is set to 'true', a associated metadata file needs to be provided for each data file. Please refer to the Documentation for the details of the metadata file content.")
        private Boolean encrypted;
        @Macro
        @Nullable
        @Description(value="The file name suffix for the metadata file of the encrypted data file. The default is '.metadata'.")
        private String encryptedMetadataSuffix;
        @Macro
        @Nullable
        @Description(value="A list of columns with the corresponding data types for whom the automatic data type detection gets skipped.")
        private String override;
        @Macro
        @Nullable
        @Description(value="The maximum number of rows that will get investigated for automatic data type detection.")
        private Long sampleSize;
        @Name(value="useConnection")
        @Nullable
        @Description(value="Whether to use an existing connection.")
        private Boolean useConnection;
        @Name(value="connection")
        @Macro
        @Nullable
        @Description(value="The existing connection to use.")
        private GCPConnectorConfig connection;

        public void validate() {
        }

        public void validate(FailureCollector collector) {
            super.validate(collector);
            ConfigUtil.validateConnection((PluginConfig)this, (Boolean)this.useConnection, (PluginConfig)this.connection, (FailureCollector)collector);
            if (!this.containsMacro(NAME_PATH)) {
                try {
                    GCSPath.from(this.path);
                }
                catch (IllegalArgumentException e) {
                    collector.addFailure(e.getMessage(), null).withConfigProperty(NAME_PATH).withStacktrace(e.getStackTrace());
                }
            }
            if (!this.containsMacro(NAME_FILE_SYSTEM_PROPERTIES)) {
                try {
                    this.getFileSystemProperties();
                }
                catch (Exception e) {
                    collector.addFailure("File system properties must be a valid json.", null).withConfigProperty(NAME_FILE_SYSTEM_PROPERTIES).withStacktrace(e.getStackTrace());
                }
            }
            if (!this.containsMacro(NAME_FILE_REGEX)) {
                try {
                    this.getFilePattern();
                }
                catch (IllegalArgumentException e) {
                    collector.addFailure(e.getMessage(), null).withConfigProperty(NAME_FILE_REGEX).withStacktrace(e.getStackTrace());
                }
            }
        }

        public String getPath() {
            return this.path;
        }

        @Nullable
        public Pattern getExclusionPattern() {
            if (!this.isEncrypted()) {
                return null;
            }
            return Pattern.compile(".*" + Pattern.quote(this.getEncryptedMetadataSuffix()) + "$");
        }

        @Nullable
        public Long getMinSplitSize() {
            return this.minSplitSize;
        }

        public boolean shouldAllowEmptyInput() {
            return false;
        }

        public boolean isCopyHeader() {
            return this.shouldCopyHeader();
        }

        public boolean isEncrypted() {
            return this.encrypted != null && this.encrypted != false;
        }

        public String getEncryptedMetadataSuffix() {
            return Strings.isNullOrEmpty((String)this.encryptedMetadataSuffix) ? DEFAULT_ENCRYPTED_METADATA_SUFFIX : this.encryptedMetadataSuffix;
        }

        Map<String, String> getFileSystemProperties() {
            if (this.fileSystemProperties == null) {
                return Collections.emptyMap();
            }
            return (Map)GSON.fromJson(this.fileSystemProperties, MAP_STRING_STRING_TYPE);
        }
    }
}

