/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.gcs.source;

import com.google.common.io.ByteStreams;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.JsonKeysetReader;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.KmsClient;
import com.google.crypto.tink.KmsClients;
import com.google.crypto.tink.StreamingAead;
import com.google.crypto.tink.config.TinkConfig;
import com.google.crypto.tink.integration.gcpkms.GcpKmsClient;
import io.cdap.plugin.gcp.crypto.Decryptor;
import io.cdap.plugin.gcp.crypto.FSInputSeekableByteChannel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.json.JSONObject;

public class TinkDecryptor
implements Decryptor,
Configurable {
    private static final String METADATA_SUFFIX = "io.cdap.crypto.metadata.suffix";
    private static final String KMS = "kms";
    private static final String KEYSET = "keyset";
    private static final String AAD = "aad";
    private Configuration configuration;
    private String metadataSuffix;

    public static Map<String, String> configure(String metadataSuffix, Map<String, String> properties) {
        properties.put(METADATA_SUFFIX, metadataSuffix);
        return properties;
    }

    public TinkDecryptor() throws GeneralSecurityException {
        TinkConfig.register();
    }

    @Override
    public SeekableByteChannel open(FileSystem fs, Path path, int bufferSize) throws IOException {
        DecryptInfo decryptInfo = this.getDecryptInfo(fs, path);
        if (decryptInfo == null) {
            throw new IllegalArgumentException("Missing encryption metadata for file '" + path + "'. Expected metadata path is '" + new Path(path.getParent(), path.getName() + this.metadataSuffix) + "'");
        }
        try {
            StreamingAead streamingAead = (StreamingAead)decryptInfo.getKeysetHandle().getPrimitive(StreamingAead.class);
            return streamingAead.newSeekableDecryptingChannel((SeekableByteChannel)new FSInputSeekableByteChannel(fs, path, bufferSize), decryptInfo.getAad());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void setConf(Configuration configuration) {
        this.configuration = configuration;
        this.metadataSuffix = configuration.get(METADATA_SUFFIX);
        if (this.metadataSuffix == null) {
            throw new IllegalArgumentException("Missing configuration 'io.cdap.crypto.metadata.suffix'");
        }
    }

    public Configuration getConf() {
        return this.configuration;
    }

    @Nullable
    private DecryptInfo getDecryptInfo(FileSystem fs, Path path) throws IOException {
        JSONObject metadata;
        Path metadataPath = new Path(path.getParent(), path.getName() + this.metadataSuffix);
        if (!fs.exists(metadataPath)) {
            return null;
        }
        try (FSDataInputStream is = fs.open(metadataPath);){
            metadata = new JSONObject(new String(ByteStreams.toByteArray((InputStream)is), StandardCharsets.UTF_8));
        }
        try {
            String kmsURI = metadata.getString(KMS);
            KmsClients.add((KmsClient)new GcpKmsClient(kmsURI).withDefaultCredentials());
            Aead aead = KmsClients.get((String)kmsURI).getAead(kmsURI);
            KeysetHandle handle = KeysetHandle.read((KeysetReader)JsonKeysetReader.withJsonObject((JSONObject)metadata.getJSONObject(KEYSET)), (Aead)aead);
            byte[] aad = Base64.getDecoder().decode(metadata.getString(AAD));
            return new DecryptInfo(handle, aad);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static final class DecryptInfo {
        private final KeysetHandle keysetHandle;
        private final byte[] aad;

        private DecryptInfo(KeysetHandle keysetHandle, byte[] aad) {
            this.keysetHandle = keysetHandle;
            this.aad = aad;
        }

        KeysetHandle getKeysetHandle() {
            return this.keysetHandle;
        }

        byte[] getAad() {
            return this.aad;
        }
    }
}

