/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.publisher.source;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.services.pubsub.PubsubScopes;
import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.spark.streaming.pubsub.SparkGCPCredentials;

public class GCPCredentialsProvider
implements SparkGCPCredentials {
    private final String serviceAccount;
    private final boolean isServiceAccountFilePath;
    private transient Credential credential;

    public GCPCredentialsProvider(@Nullable String serviceAccount, boolean isServiceAccountFilePath) {
        this.serviceAccount = serviceAccount;
        this.isServiceAccountFilePath = isServiceAccountFilePath;
    }

    @Override
    public Credential provider() {
        if (this.credential == null) {
            if (!Strings.isNullOrEmpty((String)this.serviceAccount)) {
                if (this.isServiceAccountFilePath) {
                    this.loadFromFile(this.serviceAccount);
                } else {
                    this.credential = this.loadFromJSONContent(this.serviceAccount);
                }
            } else if (this.isServiceAccountFilePath) {
                try {
                    this.credential = GoogleCredential.getApplicationDefault();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Unable to load credentials from environment", e);
                }
            } else {
                throw new IllegalArgumentException("Unable to load credentials from environment");
            }
        }
        return this.credential;
    }

    private void loadFromFile(String serviceAccountFilePath) {
        try (FileInputStream is = new FileInputStream(new File(serviceAccountFilePath));){
            this.credential = GoogleCredential.fromStream((InputStream)is).createScoped((Collection)PubsubScopes.all());
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Service account file " + serviceAccountFilePath + " does not exist.");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to load credentials from " + serviceAccountFilePath, e);
        }
    }

    private GoogleCredential loadFromJSONContent(String jsonContent) {
        ByteArrayInputStream jsonInputStream = new ByteArrayInputStream(jsonContent.getBytes());
        try {
            return GoogleCredential.fromStream((InputStream)jsonInputStream).createScoped((Collection)PubsubScopes.all());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to load credentials ", e);
        }
    }

    public static class Builder {
        private String serviceAccountFilePath;
        private boolean isServiceAccountFilePath;

        public Builder jsonServiceAccount(String serviceAccountFilePath) {
            this.serviceAccountFilePath = serviceAccountFilePath;
            return this;
        }

        public Builder setIsServiceAccountFilePath(boolean isServiceAccountFilePath) {
            this.isServiceAccountFilePath = isServiceAccountFilePath;
            return this;
        }

        public GCPCredentialsProvider build() {
            return new GCPCredentialsProvider(this.serviceAccountFilePath, this.isServiceAccountFilePath);
        }
    }
}

