/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.publisher.source;

import com.google.common.base.Strings;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.gcp.publisher.source.PubSubSubscriberConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public class GoogleSubscriberConfig
extends PubSubSubscriberConfig
implements Serializable {
    private static final String SCHEMA = "schema";
    private static final Schema DEFAULT_SCHEMA = Schema.recordOf((String)"event", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"message", (Schema)Schema.of((Schema.Type)Schema.Type.BYTES)), Schema.Field.of((String)"id", (Schema)Schema.of((Schema.Type)Schema.Type.STRING)), Schema.Field.of((String)"timestamp", (Schema)Schema.of((Schema.LogicalType)Schema.LogicalType.TIMESTAMP_MICROS)), Schema.Field.of((String)"attributes", (Schema)Schema.mapOf((Schema)Schema.of((Schema.Type)Schema.Type.STRING), (Schema)Schema.of((Schema.Type)Schema.Type.STRING)))});
    @Macro
    @Nullable
    @Description(value="Format of the data to read. Supported formats are 'avro', 'blob', 'tsv', 'csv', 'delimited', 'json', 'parquet' and 'text'.")
    protected String format;
    @Description(value="The delimiter to use if the format is 'delimited'. The delimiter will be ignored if the format is anything other than 'delimited'.")
    @Macro
    @Nullable
    protected String delimiter;
    @Name(value="schema")
    @Macro
    @Nullable
    protected String schema;

    @Override
    public void validate(FailureCollector collector) {
        super.validate(collector);
        Schema outputSchema = this.getSchema();
        ArrayList<String> defaultSchemaFields = this.getFieldsOfDefaultSchema();
        ArrayList<String> outputSchemaFields = new ArrayList<String>();
        if (outputSchema != null) {
            for (Schema.Field field : Objects.requireNonNull(outputSchema.getFields())) {
                outputSchemaFields.add(field.getName());
            }
            for (Schema.Field field : Objects.requireNonNull(DEFAULT_SCHEMA.getFields())) {
                if (outputSchemaFields.contains(field.getName())) continue;
                collector.addFailure("Some required fields are missing from the schema.", String.format("You should use the existing fields of default schema %s.", defaultSchemaFields)).withConfigProperty(this.schema);
            }
            for (Schema.Field field : Objects.requireNonNull(outputSchema.getFields())) {
                Schema.Field outputField = DEFAULT_SCHEMA.getField(field.getName());
                if (field.getSchema().isNullable()) {
                    collector.addFailure(String.format("Null is not allowed in %s.", field.getName()), "Schema is non-nullable").withConfigProperty(this.schema);
                }
                if (outputField == null) {
                    collector.addFailure(String.format("Field %s is not allowed.", field.getName()), "You should use the existing fields of default schema.").withConfigProperty(this.schema);
                    continue;
                }
                Schema.Type fieldType = field.getSchema().getType();
                if (field.getName().equals("message")) {
                    if (fieldType == Schema.Type.RECORD || fieldType == Schema.Type.BYTES) continue;
                    collector.addFailure(String.format("Type %s is not allowed in %s.", fieldType.toString().toLowerCase(), field.getName()), "Type should be record or byte.").withConfigProperty(this.schema);
                    continue;
                }
                if (fieldType.equals((Object)outputField.getSchema().getType())) continue;
                collector.addFailure(String.format("Type %s is not allowed in %s.", fieldType.toString().toLowerCase(), field.getName()), String.format("You should use the same type [%s] as in default schema.", outputField.getSchema().toString())).withConfigProperty(this.schema);
            }
        }
        if (!this.containsMacro("delimiter") && !this.containsMacro("format") && this.getFormat().equalsIgnoreCase("delimited") && this.delimiter == null) {
            collector.addFailure(String.format("Delimiter is required when format is set to %s.", this.getFormat()), "Ensure the delimiter is provided.").withConfigProperty(this.delimiter);
        }
        collector.getOrThrowException();
    }

    public String getFormat() {
        return Strings.isNullOrEmpty((String)this.format) ? "text" : this.format;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public ArrayList<String> getFieldsOfDefaultSchema() {
        ArrayList<String> outputSchemaAttributes = new ArrayList<String>();
        for (Schema.Field field : Objects.requireNonNull(DEFAULT_SCHEMA.getFields())) {
            outputSchemaAttributes.add(field.getName());
        }
        return outputSchemaAttributes;
    }

    public Schema getSchema() {
        try {
            if (this.containsMacro(SCHEMA)) {
                return null;
            }
            return Strings.isNullOrEmpty((String)this.schema) ? DEFAULT_SCHEMA : Schema.parseJson((String)this.schema);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Unable to parse schema with error %s, %s", e.getMessage(), e));
        }
    }
}

