/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.publisher.source;

import com.google.common.annotations.VisibleForTesting;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.ReceivedMessage;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class PubSubMessage
implements Externalizable {
    private String messageId;
    private String orderingKey;
    private String ackId;
    private byte[] data;
    private Map<String, String> attributes;
    private Instant publishTime;

    @VisibleForTesting
    public PubSubMessage() {
    }

    @VisibleForTesting
    public PubSubMessage(@Nullable String messageId, @Nullable String orderingKey, @Nullable String ackId, @Nullable byte[] data, @Nullable Map<String, String> attributes, @Nullable Instant publishTime) {
        this.messageId = messageId;
        this.orderingKey = orderingKey;
        this.ackId = ackId;
        this.data = data;
        this.attributes = attributes;
        this.publishTime = publishTime;
    }

    public PubSubMessage(@Nullable ReceivedMessage message) {
        if (message == null) {
            return;
        }
        PubsubMessage psMessage = message.getMessage();
        if (psMessage != null) {
            this.messageId = psMessage.getMessageId();
            this.orderingKey = psMessage.getOrderingKey();
            if (psMessage.getData() != null) {
                this.data = psMessage.getData().toByteArray();
            }
            if (psMessage.getAttributesMap() != null) {
                this.attributes = new HashMap<String, String>(psMessage.getAttributesMap());
            }
            if (psMessage.getPublishTime() != null) {
                this.publishTime = Instant.ofEpochSecond(psMessage.getPublishTime().getSeconds()).plusNanos(psMessage.getPublishTime().getNanos());
            }
        }
        this.ackId = message.getAckId();
    }

    @Nullable
    public String getMessageId() {
        return this.messageId;
    }

    @Nullable
    public String getOrderingKey() {
        return this.orderingKey;
    }

    @Nullable
    public String getAckId() {
        return this.ackId;
    }

    @Nullable
    public byte[] getData() {
        return this.data;
    }

    @Nullable
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public Instant getPublishTime() {
        return this.publishTime;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeString(out, this.messageId);
        this.writeString(out, this.orderingKey);
        this.writeString(out, this.ackId);
        this.writeInstant(out, this.publishTime);
        out.writeInt(this.attributes != null ? this.attributes.size() : -1);
        if (this.attributes != null) {
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                this.writeString(out, entry.getKey());
                this.writeString(out, entry.getValue());
            }
        }
        out.writeInt(this.data != null ? this.data.length : -1);
        if (this.data != null) {
            out.write(this.data);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.messageId = this.readString(in);
        this.orderingKey = this.readString(in);
        this.ackId = this.readString(in);
        this.publishTime = this.readInstant(in);
        int mapSize = in.readInt();
        if (mapSize >= 0) {
            this.attributes = new HashMap<String, String>();
        }
        for (int i = 0; i < mapSize; ++i) {
            String k = this.readString(in);
            String v = this.readString(in);
            this.attributes.put(k, v);
        }
        int dataSize = in.readInt();
        if (dataSize >= 0) {
            this.data = new byte[dataSize];
            in.readFully(this.data, 0, dataSize);
        }
    }

    private void writeString(ObjectOutput out, String str) throws IOException {
        if (str == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(str);
        }
    }

    private String readString(ObjectInput in) throws IOException {
        boolean isNotNull = in.readBoolean();
        if (isNotNull) {
            return in.readUTF();
        }
        return null;
    }

    private void writeInstant(ObjectOutput out, Instant instant) throws IOException {
        if (instant == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeLong(instant.getEpochSecond());
            out.writeInt(instant.getNano());
        }
    }

    private Instant readInstant(ObjectInput in) throws IOException {
        boolean isNotNull = in.readBoolean();
        if (isNotNull) {
            long epoch = in.readLong();
            int nano = in.readInt();
            return Instant.ofEpochSecond(epoch, nano);
        }
        return null;
    }
}

