/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.publisher.source;

import io.cdap.plugin.gcp.publisher.source.PubSubMessage;
import io.cdap.plugin.gcp.publisher.source.PubSubRDDIterator;
import io.cdap.plugin.gcp.publisher.source.PubSubSubscriberConfig;
import java.io.Serializable;
import java.util.Collections;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.reflect.ClassTag$;

public class PubSubRDD
extends RDD<PubSubMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(PubSubRDD.class);
    private final Time batchTime;
    private final long readDuration;
    private final PubSubSubscriberConfig config;
    private final boolean autoAcknowledge;

    PubSubRDD(SparkContext sparkContext, Time batchTime, long readDuration, PubSubSubscriberConfig config, boolean autoAcknowledge) {
        super(sparkContext, (Seq)JavaConverters.asScalaBuffer(Collections.emptyList()), ClassTag$.MODULE$.apply(PubSubMessage.class));
        this.batchTime = batchTime;
        this.readDuration = readDuration;
        this.config = config;
        this.autoAcknowledge = autoAcknowledge;
    }

    public Iterator<PubSubMessage> compute(Partition split, TaskContext context) {
        LOG.debug("Computing for partition {} .", (Object)split.index());
        return new PubSubRDDIterator(this.config, context, this.batchTime, this.readDuration, this.autoAcknowledge);
    }

    public Partition[] getPartitions() {
        int partitionCount = this.config.getNumberOfReaders();
        Partition[] partitions = new Partition[partitionCount];
        for (int i = 0; i < partitionCount; ++i) {
            int index = i;
            partitions[i] = (Partition & Serializable)() -> index;
        }
        return partitions;
    }
}

