/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.publisher.source;

import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.format.StructuredRecordStringConverter;
import io.cdap.plugin.format.avro.AvroToStructuredTransformer;
import io.cdap.plugin.gcp.common.MappingException;
import io.cdap.plugin.gcp.publisher.source.GoogleSubscriberConfig;
import io.cdap.plugin.gcp.publisher.source.PubSubMessage;
import io.cdap.plugin.gcp.publisher.source.SerializableFunction;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;

public class PubSubStructuredRecordConverter
implements SerializableFunction<PubSubMessage, StructuredRecord> {
    private final GoogleSubscriberConfig config;

    public PubSubStructuredRecordConverter(GoogleSubscriberConfig config) {
        this.config = config;
    }

    @Override
    public StructuredRecord apply(PubSubMessage pubSubMessage) {
        io.cdap.cdap.api.data.schema.Schema customMessageSchema = PubSubStructuredRecordConverter.getCustomMessageSchema(this.config);
        io.cdap.cdap.api.data.schema.Schema outputSchema = this.config.getSchema();
        String format = this.config.getFormat();
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        if (pubSubMessage.getAttributes() != null) {
            attributeMap.putAll(pubSubMessage.getAttributes());
        }
        try {
            StructuredRecord payload = PubSubStructuredRecordConverter.getStructuredRecord(this.config, customMessageSchema, format, pubSubMessage);
            return StructuredRecord.builder((io.cdap.cdap.api.data.schema.Schema)outputSchema).set("message", (Object)(format.equalsIgnoreCase("text") || format.equalsIgnoreCase("blob") ? pubSubMessage.getData() : (byte[])payload)).set("id", (Object)pubSubMessage.getMessageId()).setTimestamp("timestamp", PubSubStructuredRecordConverter.getTimestamp(pubSubMessage.getPublishTime())).set("attributes", attributeMap).build();
        }
        catch (IOException ioe) {
            throw new MappingException(ioe);
        }
    }

    private static ZonedDateTime getTimestamp(Instant instant) {
        return ZonedDateTime.ofInstant(instant, ZoneId.ofOffset("UTC", ZoneOffset.UTC));
    }

    private static Schema.Field getMessageField(GoogleSubscriberConfig config) {
        io.cdap.cdap.api.data.schema.Schema schema = config.getSchema();
        return schema.getField("message");
    }

    private static io.cdap.cdap.api.data.schema.Schema getCustomMessageSchema(GoogleSubscriberConfig config) {
        Schema.Field messageField = PubSubStructuredRecordConverter.getMessageField(config);
        if (messageField == null) {
            return null;
        }
        return messageField.getSchema();
    }

    private static StructuredRecord getStructuredRecord(GoogleSubscriberConfig config, io.cdap.cdap.api.data.schema.Schema customMessageSchema, String format, PubSubMessage pubSubMessage) throws IOException {
        StructuredRecord payload = null;
        String data = pubSubMessage.getData() != null ? new String(pubSubMessage.getData()) : "";
        switch (format) {
            case "avro": 
            case "parquet": {
                byte[] payloadData = pubSubMessage.getData();
                Schema avroSchema = new Schema.Parser().parse(String.valueOf(customMessageSchema));
                GenericDatumReader datumReader = new GenericDatumReader(avroSchema);
                ByteArrayInputStream in = new ByteArrayInputStream(payloadData);
                BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)in, null);
                GenericRecord record = (GenericRecord)datumReader.read(null, (Decoder)decoder);
                payload = new AvroToStructuredTransformer().transform(record);
                break;
            }
            case "csv": {
                payload = StructuredRecordStringConverter.fromDelimitedString((String)data, (String)",", (io.cdap.cdap.api.data.schema.Schema)customMessageSchema);
                break;
            }
            case "delimited": {
                payload = StructuredRecordStringConverter.fromDelimitedString((String)data, (String)config.getDelimiter(), (io.cdap.cdap.api.data.schema.Schema)customMessageSchema);
                break;
            }
            case "json": {
                payload = StructuredRecordStringConverter.fromJsonString((String)data, (io.cdap.cdap.api.data.schema.Schema)customMessageSchema);
                break;
            }
            case "tsv": {
                payload = StructuredRecordStringConverter.fromDelimitedString((String)data, (String)"\t", (io.cdap.cdap.api.data.schema.Schema)customMessageSchema);
            }
        }
        return payload;
    }
}

