/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.publisher.source;

import io.cdap.cdap.etl.api.streaming.StreamingContext;
import io.cdap.cdap.etl.api.streaming.StreamingSource;
import io.cdap.plugin.gcp.publisher.source.PubSubMessage;
import io.cdap.plugin.gcp.publisher.source.PubSubSubscriberConfig;
import io.cdap.plugin.gcp.publisher.source.PubSubSubscriberUtil;
import io.cdap.plugin.gcp.publisher.source.SerializableFunction;
import org.apache.spark.streaming.api.java.JavaDStream;

public abstract class PubSubSubscriber<T>
extends StreamingSource<T> {
    protected final PubSubSubscriberConfig config;
    protected SerializableFunction<PubSubMessage, T> mappingFunction;

    public PubSubSubscriber(PubSubSubscriberConfig config) {
        this.config = config;
    }

    public PubSubSubscriber(PubSubSubscriberConfig config, SerializableFunction<PubSubMessage, T> mappingFunction) {
        this.config = config;
        this.mappingFunction = mappingFunction;
    }

    public JavaDStream<T> getStream(StreamingContext context) throws Exception {
        if (this.mappingFunction == null) {
            SerializableFunction<PubSubMessage, PubSubMessage> serializableFunction = this.getMappingFunction();
            if (serializableFunction == null) {
                throw new IllegalArgumentException("Mapping Function must be specified for a PubSubSubscriber");
            }
            this.mappingFunction = serializableFunction;
        }
        return PubSubSubscriberUtil.getStream(context, this.config, this.mappingFunction);
    }

    public int getRequiredExecutors() {
        return this.config.getNumberOfReaders();
    }

    public abstract SerializableFunction<PubSubMessage, T> getMappingFunction();
}

