/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.publisher.source;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.gcp.common.GCPReferenceSourceConfig;
import java.io.Serializable;
import javax.annotation.Nullable;

public class PubSubSubscriberConfig
extends GCPReferenceSourceConfig
implements Serializable {
    public static final String NAME_SUBSCRIPTION = "subscription";
    @Description(value="Cloud Pub/Sub subscription to read from. If a subscription with the specified name does not exist, it will be automatically created if a topic is specified. Messages published before the subscription was created will not be read.")
    @Macro
    protected String subscription;
    @Description(value="Cloud Pub/Sub topic to create a subscription on. This is only used when the specified  subscription does not already exist and needs to be automatically created. If the specified subscription already exists, this value is ignored.")
    @Macro
    @Nullable
    protected String topic;
    @Description(value="Set the number of readers to run in parallel. There need to be enough workers in the cluster to run all receivers. By default, 1 reader is running per Pub/Sub Source.")
    @Macro
    @Nullable
    protected Integer numberOfReaders;

    @Override
    public void validate(FailureCollector collector) {
        super.validate(collector);
        if (this.containsMacro(NAME_SUBSCRIPTION)) {
            return;
        }
        String regAllowedChars = "[A-Za-z0-9-.%~+_]*$";
        String regStartWithLetter = "[A-Za-z]";
        if (!this.getSubscription().matches(regAllowedChars)) {
            collector.addFailure("Subscription Name does not match naming convention.", "Unexpected Character. Check Plugin documentation for naming convention.").withConfigProperty(this.subscription);
        }
        if (this.getSubscription().startsWith("goog")) {
            collector.addFailure("Subscription Name does not match naming convention.", " Cannot Start with String goog. Check Plugin documentation for naming convention.").withConfigProperty(this.subscription);
        }
        if (!this.getSubscription().substring(0, 1).matches(regStartWithLetter)) {
            collector.addFailure("Subscription Name does not match naming convention.", "Name must start with a letter. Check Plugin documentation for naming convention.").withConfigProperty(this.subscription);
        }
        if (this.getSubscription().length() < 3 || this.getSubscription().length() > 255) {
            collector.addFailure("Subscription Name does not match naming convention.", "Character Length must be between 3 and 255 characters. Check Plugin documentation for naming convention.").withConfigProperty(this.subscription);
        }
        collector.getOrThrowException();
    }

    public String getSubscription() {
        return this.subscription;
    }

    public String getTopic() {
        return this.topic;
    }

    public Integer getNumberOfReaders() {
        return this.numberOfReaders != null ? this.numberOfReaders : 1;
    }
}

