/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.spanner.connector;

import com.google.api.gax.paging.Page;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Instance;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.Statement;
import io.cdap.cdap.api.annotation.Category;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.connector.BrowseDetail;
import io.cdap.cdap.etl.api.connector.BrowseEntity;
import io.cdap.cdap.etl.api.connector.BrowseRequest;
import io.cdap.cdap.etl.api.connector.ConnectorContext;
import io.cdap.cdap.etl.api.connector.ConnectorSpec;
import io.cdap.cdap.etl.api.connector.ConnectorSpecRequest;
import io.cdap.cdap.etl.api.connector.DirectConnector;
import io.cdap.cdap.etl.api.connector.PluginSpec;
import io.cdap.cdap.etl.api.connector.SampleRequest;
import io.cdap.cdap.etl.api.validation.ValidationException;
import io.cdap.plugin.common.ReferenceNames;
import io.cdap.plugin.gcp.common.GCPConnectorConfig;
import io.cdap.plugin.gcp.spanner.common.SpannerUtil;
import io.cdap.plugin.gcp.spanner.connector.SpannerPath;
import io.cdap.plugin.gcp.spanner.source.ResultSetToRecordTransformer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

@Plugin(type="connector")
@Name(value="Spanner")
@Category(value="Google Cloud Platform")
@Description(value="Connection to access data in Spanner databases and tables.")
public class SpannerConnector
implements DirectConnector {
    public static final String NAME = "Spanner";
    public static final String ENTITY_TYPE_INSTANCE = "instance";
    public static final String ENTITY_TYPE_DATABASE = "database";
    public static final String ENTITY_TYPE_TABLE = "table";
    private static final Statement LIST_TABLES_STATEMENT = Statement.of((String)"SELECT t.table_name FROM information_schema.tables AS t WHERE t.table_catalog = '' and t.table_schema = ''");
    private static final String TABLE_NAME = "TableName";
    private static final Statement.Builder SCHEMA_STATEMENT_BUILDER = Statement.newBuilder((String)String.format("SELECT t.column_name, t.spanner_type, t.is_nullable FROM information_schema.columns AS t WHERE t.table_catalog = '' AND t.table_schema = '' AND t.table_name = @%s", "TableName"));
    private GCPConnectorConfig config;

    SpannerConnector(GCPConnectorConfig config) {
        this.config = config;
    }

    public List<StructuredRecord> sample(ConnectorContext context, SampleRequest sampleRequest) throws IOException {
        SpannerPath path = new SpannerPath(sampleRequest.getPath());
        String instance = path.getInstance();
        if (instance == null) {
            throw new IllegalArgumentException("Path should contain instance name.");
        }
        String database = path.getDatabase();
        if (database == null) {
            throw new IllegalArgumentException("Path should contain database name.");
        }
        String table = path.getTable();
        if (table == null) {
            throw new IllegalArgumentException("Path should contain table name.");
        }
        return this.getTableData(instance, database, table, sampleRequest.getLimit(), context.getFailureCollector());
    }

    public void test(ConnectorContext context) throws ValidationException {
        String project = this.config.tryGetProject();
        FailureCollector failureCollector = context.getFailureCollector();
        if (project == null) {
            failureCollector.addFailure("Could not detect Google Cloud project id from the environment.", "Please specify a project id.");
        }
        if (!failureCollector.getValidationFailures().isEmpty()) {
            return;
        }
        try (Spanner spanner = this.getSpanner();){
            spanner.getInstanceAdminClient().listInstances(new Options.ListOption[0]);
        }
        catch (Exception e) {
            failureCollector.addFailure(String.format("Could not connect to Spanner: %s", e.getMessage()), "Please specify correct connection properties.");
        }
    }

    public BrowseDetail browse(ConnectorContext context, BrowseRequest browseRequest) throws IOException {
        SpannerPath path = new SpannerPath(browseRequest.getPath());
        try (Spanner spanner = this.getSpanner();){
            if (path.isRoot()) {
                BrowseDetail browseDetail = this.listInstances(spanner, browseRequest.getLimit());
                return browseDetail;
            }
            String instance = path.getInstance();
            String database = path.getDatabase();
            String table = path.getTable();
            if (database == null) {
                BrowseDetail browseDetail = this.listDatabases(spanner, instance, browseRequest.getLimit());
                return browseDetail;
            }
            if (table == null) {
                BrowseDetail browseDetail = this.listTables(spanner, instance, database, browseRequest.getLimit());
                return browseDetail;
            }
            BrowseDetail browseDetail = this.getTableDetail(spanner, instance, database, table);
            return browseDetail;
        }
    }

    public ConnectorSpec generateSpec(ConnectorContext context, ConnectorSpecRequest connectorSpecRequest) throws IOException {
        String tableName;
        String databaseName;
        SpannerPath path = new SpannerPath(connectorSpecRequest.getPath());
        ConnectorSpec.Builder specBuilder = ConnectorSpec.builder();
        HashMap<String, String> sourceProperties = new HashMap<String, String>();
        HashMap<String, String> sinkProperties = new HashMap<String, String>();
        sourceProperties.put("useConnection", "true");
        sinkProperties.put("useConnection", "true");
        sourceProperties.put("connection", connectorSpecRequest.getConnectionWithMacro());
        sinkProperties.put("connection", connectorSpecRequest.getConnectionWithMacro());
        String instanceName = path.getInstance();
        if (instanceName != null) {
            sourceProperties.put(ENTITY_TYPE_INSTANCE, instanceName);
            sinkProperties.put(ENTITY_TYPE_INSTANCE, instanceName);
        }
        if ((databaseName = path.getDatabase()) != null) {
            sourceProperties.put(ENTITY_TYPE_DATABASE, databaseName);
            sinkProperties.put(ENTITY_TYPE_DATABASE, databaseName);
        }
        if ((tableName = path.getTable()) != null) {
            sourceProperties.put(ENTITY_TYPE_TABLE, tableName);
            sinkProperties.put(ENTITY_TYPE_TABLE, tableName);
            sourceProperties.put("referenceName", ReferenceNames.cleanseReferenceName((String)(instanceName + "." + databaseName + "." + tableName)));
            Schema schema = this.getTableSchema(instanceName, databaseName, tableName, context.getFailureCollector());
            specBuilder.setSchema(schema);
        }
        return specBuilder.addRelatedPlugin(new PluginSpec(NAME, "batchsource", sourceProperties)).addRelatedPlugin(new PluginSpec(NAME, "batchsink", sinkProperties)).build();
    }

    private Schema getTableSchema(String instance, String database, String table, FailureCollector collector) throws IOException {
        try (Spanner spanner = this.getSpanner();){
            Schema schema = SpannerUtil.getTableSchema(spanner, this.config.getProject(), instance, database, table, collector);
            return schema;
        }
    }

    private BrowseDetail listInstances(Spanner spanner, Integer limit) {
        Page page = spanner.getInstanceAdminClient().listInstances(new Options.ListOption[0]);
        int countLimit = limit == null || limit <= 0 ? Integer.MAX_VALUE : limit;
        int count = 0;
        BrowseDetail.Builder browseDetailBuilder = BrowseDetail.builder();
        for (Instance instance : page.iterateAll()) {
            if (count >= countLimit) break;
            String name = instance.getId().getInstance();
            browseDetailBuilder.addEntity(BrowseEntity.builder((String)name, (String)("/" + name), (String)ENTITY_TYPE_INSTANCE).canBrowse(true).build());
            ++count;
        }
        return browseDetailBuilder.setTotalCount(count).build();
    }

    private BrowseDetail listDatabases(Spanner spanner, String instance, Integer limit) {
        Page page = spanner.getDatabaseAdminClient().listDatabases(instance, new Options.ListOption[0]);
        int countLimit = limit == null || limit <= 0 ? Integer.MAX_VALUE : limit;
        int count = 0;
        BrowseDetail.Builder browseDetailBuilder = BrowseDetail.builder();
        String pathPrefix = "/" + instance + "/";
        for (Database database : page.iterateAll()) {
            if (count >= countLimit) break;
            String name = database.getId().getDatabase();
            browseDetailBuilder.addEntity(BrowseEntity.builder((String)name, (String)(pathPrefix + name), (String)ENTITY_TYPE_DATABASE).canBrowse(true).build());
            ++count;
        }
        return browseDetailBuilder.setTotalCount(count).build();
    }

    private BrowseDetail listTables(Spanner spanner, String instance, String database, Integer limit) {
        int count;
        ResultSet resultSet = spanner.getDatabaseClient(DatabaseId.of((String)this.config.getProject(), (String)instance, (String)database)).singleUse().executeQuery(LIST_TABLES_STATEMENT, new Options.QueryOption[0]);
        int countLimit = limit == null || limit <= 0 ? Integer.MAX_VALUE : limit;
        BrowseDetail.Builder browseDetailBuilder = BrowseDetail.builder();
        String pathPrefix = "/" + instance + "/" + database + "/";
        for (count = 0; resultSet.next() && count < countLimit; ++count) {
            String name = resultSet.getString("table_name");
            browseDetailBuilder.addEntity(BrowseEntity.builder((String)name, (String)(pathPrefix + name), (String)ENTITY_TYPE_TABLE).canSample(true).build());
        }
        return browseDetailBuilder.setTotalCount(count).build();
    }

    private BrowseDetail getTableDetail(Spanner spanner, String instance, String database, String table) {
        Statement getTableSchemaStatement = ((Statement.Builder)SCHEMA_STATEMENT_BUILDER.bind(TABLE_NAME).to(table)).build();
        Throwable throwable = null;
        try (ResultSet resultSet = spanner.getDatabaseClient(DatabaseId.of((String)this.config.getProject(), (String)instance, (String)database)).singleUse().executeQuery(getTableSchemaStatement, new Options.QueryOption[0]);){
            if (resultSet.next()) {
                String path = "/" + instance + "/" + database + "/" + table;
                BrowseDetail browseDetail = BrowseDetail.builder().addEntity(BrowseEntity.builder((String)table, (String)path, (String)ENTITY_TYPE_TABLE).canSample(true).build()).setTotalCount(1).build();
                return browseDetail;
            }
            try {
                throw new IllegalArgumentException(String.format("Cannot find table: %s", table));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private List<StructuredRecord> getTableData(String instance, String database, String table, int limit, FailureCollector collector) throws IOException {
        ArrayList<StructuredRecord> records = new ArrayList<StructuredRecord>();
        try (Spanner spanner = this.getSpanner();){
            Schema schema = this.getTableSchema(instance, database, table, collector);
            List columnNames = schema.getFields().stream().map(Schema.Field::getName).collect(Collectors.toList());
            ResultSet resultSet = spanner.getDatabaseClient(DatabaseId.of((String)this.config.getProject(), (String)instance, (String)database)).singleUse().read(table, KeySet.all(), columnNames, new Options.ReadOption[]{Options.limit((long)limit)});
            ResultSetToRecordTransformer transformer = new ResultSetToRecordTransformer(schema);
            while (resultSet.next()) {
                records.add(transformer.transform(resultSet));
            }
            ArrayList<StructuredRecord> arrayList = records;
            return arrayList;
        }
    }

    private Spanner getSpanner() throws IOException {
        return SpannerUtil.getSpannerService(this.config.getServiceAccount(), this.config.isServiceAccountFilePath(), this.config.getProject());
    }
}

