/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.spanner.connector;

import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class SpannerPath {
    private String instance;
    private String database;
    private String table;
    private static final int NAME_MAX_LENGTH = 1024;
    private static final Pattern VALID_NAME_REGEX = Pattern.compile("[\\w-]+");

    public SpannerPath(String path) {
        this.parsePath(path);
    }

    private void parsePath(String path) {
        String[] parts;
        if (path == null) {
            throw new IllegalArgumentException("Path should not be null.");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.isEmpty()) {
            return;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((parts = path.split("/", -1)).length > 3) {
            throw new IllegalArgumentException("Path should at most contain three parts.");
        }
        this.instance = parts[0];
        this.validateName("Instance", this.instance);
        if (parts.length == 1) {
            return;
        }
        this.database = parts[1];
        this.validateName("Database", this.database);
        if (parts.length == 3) {
            this.table = parts[2];
            this.validateName("Table", this.table);
        }
    }

    private void validateName(String property, String name) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException(String.format("%s should not be empty.", property));
        }
        if (name.length() > 1024) {
            throw new IllegalArgumentException(String.format("%s is invalid, it should contain at most %d characters.", property, 1024));
        }
        if (!VALID_NAME_REGEX.matcher(name).matches()) {
            throw new IllegalArgumentException(String.format("%s is invalid, it should contain only letters, numbers, and underscores.", property));
        }
    }

    @Nullable
    public String getInstance() {
        return this.instance;
    }

    @Nullable
    public String getDatabase() {
        return this.database;
    }

    @Nullable
    public String getTable() {
        return this.table;
    }

    public boolean isRoot() {
        return this.instance == null && this.database == null && this.table == null;
    }
}

