/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.spanner.sink;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Value;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.format.UnexpectedFormatException;
import io.cdap.cdap.api.data.schema.Schema;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class RecordToMutationTransformer {
    private final String tableName;
    private final Schema schema;

    public RecordToMutationTransformer(String tableName, @Nullable Schema schema) {
        this.tableName = tableName;
        this.schema = schema;
    }

    public Mutation transform(StructuredRecord record) {
        Mutation.WriteBuilder builder = Mutation.newInsertOrUpdateBuilder((String)this.tableName);
        List fields = this.schema != null ? this.schema.getFields() : record.getSchema().getFields();
        for (Schema.Field field : fields) {
            String name = field.getName();
            Schema fieldSchema = field.getSchema();
            builder.set(name).to(this.convertToValue(name, fieldSchema, record));
        }
        return builder.build();
    }

    Value convertToValue(String fieldName, Schema fieldSchema, StructuredRecord record) {
        Schema schema = fieldSchema.isNullable() ? fieldSchema.getNonNullable() : fieldSchema;
        Schema.LogicalType logicalType = schema.getLogicalType();
        if (logicalType != null && record.get(fieldName) != null) {
            switch (logicalType) {
                case DATE: {
                    LocalDate date = record.getDate(fieldName);
                    Date spannerDate = Date.fromYearMonthDay((int)date.getYear(), (int)date.getMonthValue(), (int)date.getDayOfMonth());
                    return Value.date((Date)spannerDate);
                }
                case TIMESTAMP_MILLIS: 
                case TIMESTAMP_MICROS: {
                    ZonedDateTime ts = record.getTimestamp(fieldName);
                    Timestamp spannerTs = Timestamp.ofTimeSecondsAndNanos((long)ts.toEpochSecond(), (int)ts.getNano());
                    return Value.timestamp((Timestamp)spannerTs);
                }
                case DATETIME: {
                    return Value.string((String)((String)record.get(fieldName)));
                }
            }
            throw new IllegalStateException(String.format("Field '%s' is of unsupported logical type '%s'", fieldName, logicalType.getToken()));
        }
        Schema.Type type = schema.getType();
        switch (type) {
            case BOOLEAN: {
                return Value.bool((Boolean)((Boolean)record.get(fieldName)));
            }
            case STRING: {
                return Value.string((String)((String)record.get(fieldName)));
            }
            case INT: {
                Integer intValue = (Integer)record.get(fieldName);
                if (intValue == null) {
                    return Value.int64(null);
                }
                return Value.int64((long)intValue.longValue());
            }
            case LONG: {
                return Value.int64((Long)((Long)record.get(fieldName)));
            }
            case FLOAT: {
                Float floatValue = (Float)record.get(fieldName);
                if (floatValue == null) {
                    return Value.float64(null);
                }
                return Value.float64((double)floatValue.doubleValue());
            }
            case DOUBLE: {
                return Value.float64((Double)((Double)record.get(fieldName)));
            }
            case BYTES: {
                Object byteObject = record.get(fieldName);
                if (byteObject == null) {
                    return Value.bytes(null);
                }
                if (byteObject instanceof ByteBuffer) {
                    return Value.bytes((ByteArray)ByteArray.copyFrom((ByteBuffer)((ByteBuffer)byteObject)));
                }
                return Value.bytes((ByteArray)ByteArray.copyFrom((byte[])((byte[])byteObject)));
            }
            case ARRAY: {
                Schema componentSchema = schema.getComponentSchema();
                if (componentSchema == null) {
                    throw new IllegalStateException(String.format("Component schema of array field '%s' is null", fieldName));
                }
                return this.transformCollectionToValue(fieldName, componentSchema, record.get(fieldName));
            }
        }
        throw new IllegalStateException(String.format("Field '%s' is of unsupported type '%s'", fieldName, type));
    }

    private Value transformCollectionToValue(String name, Schema schema, Object object) {
        Schema componentSchema = schema.isNullable() ? schema.getNonNullable() : schema;
        Schema elementSchema = Schema.recordOf((String)"arrayElementSchema", (Schema.Field[])new Schema.Field[]{Schema.Field.of((String)name, (Schema)Schema.nullableOf((Schema)componentSchema))});
        Collection<Object> arrayValues = RecordToMutationTransformer.toCollection(name, componentSchema.getType().toString(), object);
        List values = arrayValues.stream().map(value -> {
            StructuredRecord structuredRecord = StructuredRecord.builder((Schema)elementSchema).set(name, value).build();
            return this.convertToValue(name, elementSchema.getField(name).getSchema(), structuredRecord);
        }).collect(Collectors.toList());
        Schema.LogicalType logicalType = componentSchema.getLogicalType();
        if (logicalType != null) {
            switch (logicalType) {
                case DATE: {
                    return Value.dateArray((Iterable)values.stream().map(value -> value.isNull() ? null : value.getDate()).collect(Collectors.toList()));
                }
                case TIMESTAMP_MILLIS: 
                case TIMESTAMP_MICROS: {
                    return Value.timestampArray((Iterable)values.stream().map(value -> value.isNull() ? null : value.getTimestamp()).collect(Collectors.toList()));
                }
            }
            throw new IllegalStateException(String.format("Field '%s' is an array of unsupported logical type '%s'", name, logicalType.getToken()));
        }
        Schema.Type type = componentSchema.getType();
        switch (type) {
            case BOOLEAN: {
                return Value.boolArray((Iterable)values.stream().map(value -> value.isNull() ? null : Boolean.valueOf(value.getBool())).collect(Collectors.toList()));
            }
            case STRING: {
                return Value.stringArray((Iterable)values.stream().map(value -> value.isNull() ? null : value.getString()).collect(Collectors.toList()));
            }
            case INT: 
            case LONG: {
                return Value.int64Array((Iterable)values.stream().map(value -> value.isNull() ? null : Long.valueOf(value.getInt64())).collect(Collectors.toList()));
            }
            case FLOAT: 
            case DOUBLE: {
                return Value.float64Array((Iterable)values.stream().map(value -> value.isNull() ? null : Double.valueOf(value.getFloat64())).collect(Collectors.toList()));
            }
            case BYTES: {
                return Value.bytesArray((Iterable)values.stream().map(value -> value.isNull() ? null : value.getBytes()).collect(Collectors.toList()));
            }
        }
        throw new IllegalStateException(String.format("Field '%s' is an array of '%s', which is not supported.", name, type));
    }

    static Collection<Object> toCollection(String fieldName, String fieldType, Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value.getClass().isArray()) {
            return RecordToMutationTransformer.convertToObjectCollection(value);
        }
        throw new UnexpectedFormatException(String.format("Field '%s' of type '%s' has unexpected value '%s'", fieldName, fieldType, value));
    }

    private static Collection<Object> convertToObjectCollection(Object array) {
        Class<?> ofArray = array.getClass().getComponentType();
        if (ofArray.isPrimitive()) {
            ArrayList<Object> list = new ArrayList<Object>();
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(array, i));
            }
            return list;
        }
        return Arrays.asList((Object[])array);
    }
}

