/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.spanner.sink;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.common.ConfigUtil;
import io.cdap.plugin.common.IdUtils;
import io.cdap.plugin.common.ReferenceNames;
import io.cdap.plugin.gcp.common.CmekUtils;
import io.cdap.plugin.gcp.common.GCPConnectorConfig;
import io.cdap.plugin.gcp.spanner.common.SpannerUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class SpannerSinkConfig
extends PluginConfig {
    private static final int DEFAULT_SPANNER_WRITE_BATCH_SIZE = 100;
    private static final Set<Schema.Type> SUPPORTED_TYPES = ImmutableSet.of((Object)Schema.Type.BOOLEAN, (Object)Schema.Type.STRING, (Object)Schema.Type.INT, (Object)Schema.Type.LONG, (Object)Schema.Type.FLOAT, (Object)Schema.Type.DOUBLE, (Object[])new Schema.Type[]{Schema.Type.BYTES, Schema.Type.ARRAY});
    public static final String NAME_TABLE = "table";
    public static final String NAME_BATCH_SIZE = "batchSize";
    public static final String NAME_INSTANCE = "instance";
    public static final String NAME_DATABASE = "database";
    public static final String NAME_KEYS = "keys";
    public static final String NAME_SCHEMA = "schema";
    private static final String NAME_CMEK_KEY = "cmekKey";
    @Name(value="table")
    @Description(value="Cloud Spanner table id. Uniquely identifies your table within the Cloud Spanner database")
    @Macro
    private String table;
    @Name(value="batchSize")
    @Description(value="Size of the batched writes to the Spanner table. When the number of buffered mutations is greater than this batchSize, the mutations are written to Spanner table, Default value is 100")
    @Macro
    @Nullable
    private Integer batchSize;
    @Name(value="instance")
    @Description(value="Cloud Spanner instance id. Uniquely identifies Cloud Spanner instance within your Google Cloud Platform project.")
    @Macro
    private String instance;
    @Name(value="database")
    @Description(value="Cloud Spanner database id. Uniquely identifies your database within the Cloud Spanner instance.")
    @Macro
    private String database;
    @Name(value="keys")
    @Nullable
    @Description(value="Primary keys to be used to create spanner table, if the spanner table does not exist.")
    @Macro
    private String keys;
    @Name(value="schema")
    @Nullable
    @Description(value="Schema of the Spanner table.")
    @Macro
    private String schema;
    @Name(value="cmekKey")
    @Macro
    @Nullable
    @Description(value="The GCP customer managed encryption key (CMEK) name used to encrypt data written to any database created by the plugin. If the database already exists, this is ignored.  More information can be found at https://cloud.google.com/data-fusion/docs/how-to/customer-managed-encryption-keys")
    protected String cmekKey;
    @Name(value="referenceName")
    @Nullable
    @Description(value="This will be used to uniquely identify this source for lineage, annotating metadata, etc.")
    public String referenceName;
    @Name(value="useConnection")
    @Nullable
    @Description(value="Whether to use an existing connection.")
    private Boolean useConnection;
    @Name(value="connection")
    @Macro
    @Nullable
    @Description(value="The existing connection to use.")
    protected GCPConnectorConfig connection;

    public SpannerSinkConfig(String referenceName, String table, @Nullable Integer batchSize, String instance, String database, @Nullable String keys, String schema, @Nullable String cmekKey) {
        this.referenceName = referenceName;
        this.table = table;
        this.batchSize = batchSize;
        this.instance = instance;
        this.database = database;
        this.keys = keys;
        this.schema = schema;
        this.cmekKey = cmekKey;
    }

    public String getReferenceName() {
        return Strings.isNullOrEmpty((String)this.referenceName) ? ReferenceNames.normalizeFqn((String)this.getFQN()) : this.referenceName;
    }

    public String getTable() {
        return this.table;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getDatabase() {
        return this.database;
    }

    @Nullable
    public String getKeys() {
        return this.keys;
    }

    public void validate(FailureCollector collector) {
        this.validate(collector, Collections.emptyMap());
    }

    public void validate(FailureCollector collector, Map<String, String> arguments) {
        if (!Strings.isNullOrEmpty((String)this.referenceName)) {
            IdUtils.validateReferenceName((String)this.referenceName, (FailureCollector)collector);
        }
        ConfigUtil.validateConnection((PluginConfig)this, (Boolean)this.useConnection, (PluginConfig)this.connection, (FailureCollector)collector);
        Schema schema = this.getSchema(collector);
        if (!this.containsMacro(NAME_SCHEMA) && schema != null) {
            SpannerUtil.validateSchema(schema, SUPPORTED_TYPES, collector);
        }
        if (!this.containsMacro(NAME_BATCH_SIZE) && this.batchSize != null && this.batchSize < 1) {
            collector.addFailure("Invalid spanner batch size for writes.", "Ensure the value is a positive number.").withConfigProperty(NAME_BATCH_SIZE);
        }
        if (!this.containsMacro(NAME_KEYS) && this.keys != null && !this.containsMacro(NAME_SCHEMA) && schema != null) {
            String[] splitted;
            for (String key : splitted = this.keys.split(",")) {
                if (schema.getField(key.trim()) != null) continue;
                collector.addFailure(String.format("Primary key field '%s' does not exist in the schema.", key), "Change the Primary key field to be one of the schema fields.").withConfigElement(NAME_KEYS, key);
            }
        }
        if (!this.containsMacro(NAME_CMEK_KEY)) {
            CmekUtils.getCmekKey(this.cmekKey, arguments, collector);
        }
    }

    @Nullable
    public Schema getSchema(FailureCollector collector) {
        if (Strings.isNullOrEmpty((String)this.schema)) {
            return null;
        }
        try {
            return Schema.parseJson((String)this.schema);
        }
        catch (IOException e) {
            collector.addFailure("Invalid schema: " + e.getMessage(), null).withConfigProperty(NAME_SCHEMA);
            throw collector.getOrThrowException();
        }
    }

    public int getBatchSize() {
        return this.batchSize == null ? 100 : this.batchSize;
    }

    public String getFQN() {
        String secondFQNPart = String.join((CharSequence)".", this.instance, this.database, this.table);
        return "spanner://" + secondFQNPart;
    }
}

