/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.spanner.source;

import com.google.cloud.spanner.Partition;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionInputSplit
extends InputSplit
implements Writable {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionInputSplit.class);
    private Partition partition;

    public PartitionInputSplit() {
    }

    public PartitionInputSplit(Partition partition) throws Exception {
        this.partition = partition;
    }

    public long getLength() throws IOException, InterruptedException {
        return 0L;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return new String[0];
    }

    public void write(DataOutput dataOutput) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
            objectOutputStream.writeObject(this.partition);
            objectOutputStream.flush();
            byte[] objectBytes = byteArrayOutputStream.toByteArray();
            dataOutput.writeInt(objectBytes.length);
            dataOutput.write(objectBytes);
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        int byteLength = dataInput.readInt();
        byte[] readArray = new byte[byteLength];
        dataInput.readFully(readArray);
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(readArray);
             ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);){
            this.partition = (Partition)objectInputStream.readObject();
        }
        catch (ClassNotFoundException cfe) {
            throw new IOException("Exception while trying to deserialize object ", cfe);
        }
    }

    public Partition getPartition() {
        return this.partition;
    }
}

