/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.spanner.source;

import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.BatchTransactionId;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import io.cdap.plugin.gcp.spanner.common.BytesCounter;
import io.cdap.plugin.gcp.spanner.common.SpannerUtil;
import io.cdap.plugin.gcp.spanner.source.PartitionInputSplit;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormatCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpannerRecordReader
extends RecordReader<NullWritable, ResultSet> {
    private static final Logger LOG = LoggerFactory.getLogger(SpannerRecordReader.class);
    private final BatchTransactionId batchTransactionId;
    private ResultSet resultSet;
    private Counter bytesRead;
    private Spanner spanner;
    BytesCounter counter;

    public SpannerRecordReader(BatchTransactionId batchTransactionId) {
        this.batchTransactionId = batchTransactionId;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        PartitionInputSplit partitionInputSplit = (PartitionInputSplit)inputSplit;
        try {
            Configuration configuration = context.getConfiguration();
            boolean isServiceAccountFilePath = "serviceFilePath".equals(configuration.get("service.account.type"));
            this.bytesRead = context.getCounter((Enum)FileInputFormatCounter.BYTES_READ);
            this.counter = new BytesCounter();
            this.spanner = SpannerUtil.getSpannerServiceWithReadInterceptor(configuration.get("service.account.path"), isServiceAccountFilePath, configuration.get("project.id"), this.counter);
            BatchClient batchClient = this.spanner.getBatchClient(DatabaseId.of((String)configuration.get("project.id"), (String)configuration.get("instance.id"), (String)configuration.get("database.name")));
            BatchReadOnlyTransaction transaction = batchClient.batchReadOnlyTransaction(this.batchTransactionId);
            this.resultSet = transaction.execute(partitionInputSplit.getPartition());
        }
        catch (Exception e) {
            throw new IOException("Exception while trying to execute query to get result set ", e);
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.resultSet != null && this.resultSet.next();
    }

    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    public ResultSet getCurrentValue() throws IOException, InterruptedException {
        return this.resultSet;
    }

    public float getProgress() throws IOException, InterruptedException {
        return 0.0f;
    }

    public void close() throws IOException {
        LOG.trace("Closing Record reader");
        this.bytesRead.increment(this.counter.getValue());
        this.resultSet.close();
        if (this.spanner != null) {
            this.spanner.close();
        }
    }
}

