/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.gcp.spanner.source;

import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.plugin.common.ConfigUtil;
import io.cdap.plugin.common.IdUtils;
import io.cdap.plugin.common.ReferenceNames;
import io.cdap.plugin.gcp.common.GCPConnectorConfig;
import io.cdap.plugin.gcp.spanner.common.SpannerUtil;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;

public class SpannerSourceConfig
extends PluginConfig {
    private static final Set<Schema.Type> SUPPORTED_TYPES = ImmutableSet.of((Object)Schema.Type.BOOLEAN, (Object)Schema.Type.STRING, (Object)Schema.Type.LONG, (Object)Schema.Type.DOUBLE, (Object)Schema.Type.BYTES, (Object)Schema.Type.ARRAY, (Object[])new Schema.Type[0]);
    public static final String NAME_MAX_PARTITIONS = "maxPartitions";
    public static final String NAME_PARTITION_SIZE_MB = "partitionSizeMB";
    public static final String NAME_INSTANCE = "instance";
    public static final String NAME_DATABASE = "database";
    public static final String NAME_TABLE = "table";
    public static final String NAME_IMPORT_QUERY = "importQuery";
    public static final String NAME_SCHEMA = "schema";
    @Name(value="referenceName")
    @Description(value="This will be used to uniquely identify this source for lineage, annotating metadata, etc.")
    public String referenceName;
    @Description(value="Maximum number of partitions. This is only a hint. The actual number of partitions may vary")
    @Macro
    @Nullable
    public Long maxPartitions;
    @Description(value="Partition size in megabytes. This is only a hint. The actual partition size may vary")
    @Macro
    @Nullable
    public Long partitionSizeMB;
    @Description(value="Cloud Spanner instance id. Uniquely identifies Cloud Spanner instance within your Google Cloud Platform project.")
    @Macro
    public String instance;
    @Description(value="Cloud Spanner database id. Uniquely identifies your database within the Cloud Spanner instance.")
    @Macro
    public String database;
    @Description(value="Cloud Spanner table id. Uniquely identifies your table within the Cloud Spanner database")
    @Macro
    public String table;
    @Description(value="The SELECT query to use to import data from the specified table.")
    @Macro
    @Nullable
    public String importQuery;
    @Description(value="Schema of the Spanner table.")
    @Macro
    @Nullable
    public String schema;
    @Name(value="useConnection")
    @Nullable
    @Description(value="Whether to use an existing connection.")
    private Boolean useConnection;
    @Name(value="connection")
    @Macro
    @Nullable
    @Description(value="The existing connection to use.")
    private GCPConnectorConfig connection;

    public String getProject() {
        if (this.connection == null) {
            throw new IllegalArgumentException("Could not get project information, connection should not be null!");
        }
        return this.connection.getProject();
    }

    @Nullable
    public String tryGetProject() {
        return this.connection == null ? null : this.connection.tryGetProject();
    }

    @Nullable
    public String getServiceAccount() {
        return this.connection == null ? null : this.connection.getServiceAccount();
    }

    @Nullable
    public Boolean isServiceAccountFilePath() {
        return this.connection == null ? null : this.connection.isServiceAccountFilePath();
    }

    @Nullable
    public String getServiceAccountType() {
        return this.connection == null ? null : this.connection.getServiceAccountType();
    }

    @Nullable
    public GCPConnectorConfig getConnection() {
        return this.connection;
    }

    public String getReferenceName() {
        return Strings.isNullOrEmpty((String)this.referenceName) ? ReferenceNames.normalizeFqn((String)this.getFQN()) : this.referenceName;
    }

    public boolean autoServiceAccountUnavailable() {
        if (this.connection == null || this.connection.getServiceAccountFilePath() == null && this.connection.isServiceAccountFilePath().booleanValue()) {
            try {
                ServiceAccountCredentials.getApplicationDefault();
            }
            catch (IOException e) {
                return true;
            }
        }
        return false;
    }

    public void validate(FailureCollector collector) {
        IdUtils.validateReferenceName((String)this.referenceName, (FailureCollector)collector);
        ConfigUtil.validateConnection((PluginConfig)this, (Boolean)this.useConnection, (PluginConfig)this.connection, (FailureCollector)collector);
        Schema schema = this.getSchema(collector);
        if (!this.containsMacro(NAME_SCHEMA) && schema != null) {
            SpannerUtil.validateSchema(schema, SUPPORTED_TYPES, collector);
        }
        if (!this.containsMacro(NAME_MAX_PARTITIONS) && this.maxPartitions != null && this.maxPartitions < 1L) {
            collector.addFailure("Invalid max partitions.", "Ensure the value is a positive number.").withConfigProperty(NAME_MAX_PARTITIONS);
        }
        if (!this.containsMacro(NAME_PARTITION_SIZE_MB) && this.partitionSizeMB != null && this.partitionSizeMB < 1L) {
            collector.addFailure("Invalid partition size in mega bytes.", "Ensure the value is a positive number.").withConfigProperty(NAME_PARTITION_SIZE_MB);
        }
    }

    @Nullable
    public Schema getSchema(FailureCollector collector) {
        try {
            return Strings.isNullOrEmpty((String)this.schema) ? null : Schema.parseJson((String)this.schema);
        }
        catch (IOException e) {
            collector.addFailure("Invalid schema: " + e.getMessage(), null).withConfigProperty(NAME_SCHEMA);
            throw collector.getOrThrowException();
        }
    }

    public boolean canConnect() {
        return this.connection != null && this.connection.canConnect() && !this.containsMacro(NAME_SCHEMA) && !this.containsMacro(NAME_DATABASE) && !this.containsMacro(NAME_TABLE) && !this.containsMacro(NAME_INSTANCE) && !this.containsMacro(NAME_IMPORT_QUERY);
    }

    public String getFQN() {
        String secondFQNPart = String.join((CharSequence)".", this.instance, this.database, this.table);
        return "spanner://" + secondFQNPart;
    }
}

