/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombineClassLoader
extends URLClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(CombineClassLoader.class);
    private final List<ClassLoader> delegates;

    public CombineClassLoader(@Nullable ClassLoader parent, ClassLoader ... delegates) {
        this(parent, Arrays.asList(delegates));
    }

    public CombineClassLoader(@Nullable ClassLoader parent, Iterable<? extends ClassLoader> delegates) {
        super(new URL[0], parent);
        this.delegates = ImmutableList.copyOf(delegates);
    }

    @Override
    public URL[] getURLs() {
        ArrayList urls = new ArrayList();
        for (ClassLoader delegate : this.delegates) {
            if (!(delegate instanceof URLClassLoader)) continue;
            Collections.addAll(urls, ((URLClassLoader)delegate).getURLs());
        }
        return urls.toArray(new URL[0]);
    }

    public List<ClassLoader> getDelegates() {
        return this.delegates;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.delegates) {
            try {
                return classLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                LOG.trace("Class {} not found in ClassLoader {}", (Object)name, (Object)classLoader);
            }
        }
        throw new ClassNotFoundException("Class not found in all delegated ClassLoaders: " + name);
    }

    @Override
    public URL findResource(String name) {
        for (ClassLoader classLoader : this.delegates) {
            URL url = classLoader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        LinkedHashSet urls = Sets.newLinkedHashSet();
        for (ClassLoader classLoader : this.delegates) {
            Iterators.addAll((Collection)urls, (Iterator)Iterators.forEnumeration(classLoader.getResources(name)));
        }
        return Iterators.asEnumeration(urls.iterator());
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (ClassLoader classLoader : this.delegates) {
            InputStream is = classLoader.getResourceAsStream(name);
            if (is == null) continue;
            return is;
        }
        return null;
    }
}

