/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common;

import io.cdap.cdap.api.common.Bytes;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.common.KeystoreConf;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.codec.binary.Hex;

public abstract class FieldEncryptor {
    private final KeystoreConf conf;
    private int mode;
    private Cipher cipher;

    public FieldEncryptor(KeystoreConf conf, int mode) {
        this.mode = mode;
        this.conf = conf;
    }

    public void initialize() throws Exception {
        KeyStore keystore = KeyStore.getInstance(this.conf.getKeystoreType());
        try (InputStream keystoreStream = this.getKeystoreInputStream(this.conf.getKeystorePath());){
            keystore.load(keystoreStream, this.conf.getKeystorePassword().toCharArray());
        }
        Key key = keystore.getKey(this.conf.getKeyAlias(), this.conf.getKeyPassword().toCharArray());
        this.cipher = Cipher.getInstance(this.conf.getTransformation());
        if (this.conf.getIvHex() != null) {
            byte[] ivBytes = Hex.decodeHex((char[])this.conf.getIvHex().toCharArray());
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivBytes);
            this.cipher.init(this.mode, key, ivParameterSpec);
        } else {
            this.cipher.init(this.mode, key);
        }
    }

    public abstract InputStream getKeystoreInputStream(String var1) throws Exception;

    public byte[] encrypt(Object fieldVal, Schema fieldSchema) throws BadPaddingException, IllegalBlockSizeException {
        byte[] fieldBytes;
        if (fieldVal == null) {
            return null;
        }
        Schema.Type fieldType = fieldSchema.isNullable() ? fieldSchema.getNonNullable().getType() : fieldSchema.getType();
        switch (fieldType) {
            case INT: {
                fieldBytes = Bytes.toBytes((int)((Integer)fieldVal));
                break;
            }
            case LONG: {
                fieldBytes = Bytes.toBytes((long)((Long)fieldVal));
                break;
            }
            case FLOAT: {
                fieldBytes = Bytes.toBytes((float)((Float)fieldVal).floatValue());
                break;
            }
            case DOUBLE: {
                fieldBytes = Bytes.toBytes((double)((Double)fieldVal));
                break;
            }
            case STRING: {
                fieldBytes = Bytes.toBytes((String)((String)fieldVal));
                break;
            }
            case BYTES: {
                fieldBytes = (byte[])fieldVal;
                break;
            }
            default: {
                throw new IllegalArgumentException("field type " + fieldType + " is not supported.");
            }
        }
        return this.cipher.doFinal(fieldBytes);
    }

    public Object decrypt(byte[] fieldBytes, Schema fieldSchema) throws BadPaddingException, IllegalBlockSizeException {
        if (fieldBytes == null) {
            return null;
        }
        Schema.Type fieldType = fieldSchema.isNullable() ? fieldSchema.getNonNullable().getType() : fieldSchema.getType();
        fieldBytes = this.cipher.doFinal(fieldBytes);
        switch (fieldType) {
            case INT: {
                return Bytes.toInt((byte[])fieldBytes);
            }
            case LONG: {
                return Bytes.toLong((byte[])fieldBytes);
            }
            case FLOAT: {
                return Float.valueOf(Bytes.toFloat((byte[])fieldBytes));
            }
            case DOUBLE: {
                return Bytes.toDouble((byte[])fieldBytes);
            }
            case STRING: {
                return Bytes.toString((byte[])fieldBytes);
            }
            case BYTES: {
                return fieldBytes;
            }
        }
        throw new IllegalArgumentException("field type " + fieldType + " is not supported.");
    }
}

