/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common;

import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.data.schema.UnsupportedTypeException;
import java.util.Iterator;
import java.util.Map;

public final class HiveSchemaConverter {
    private HiveSchemaConverter() {
    }

    public static String toHiveSchema(Schema schema) throws UnsupportedTypeException {
        if (schema.getType() != Schema.Type.RECORD || schema.getFields().size() < 1) {
            throw new UnsupportedTypeException("Schema must be of type record and have at least one field.");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        Iterator fieldIter = schema.getFields().iterator();
        HiveSchemaConverter.appendField(builder, (Schema.Field)fieldIter.next(), false);
        while (fieldIter.hasNext()) {
            builder.append(", ");
            HiveSchemaConverter.appendField(builder, (Schema.Field)fieldIter.next(), false);
        }
        builder.append(")");
        return builder.toString();
    }

    public static void appendType(StringBuilder builder, Schema schema) throws UnsupportedTypeException {
        switch (schema.getType()) {
            case NULL: {
                break;
            }
            case ENUM: {
                builder.append("string");
                break;
            }
            case BOOLEAN: {
                builder.append("boolean");
                break;
            }
            case INT: {
                builder.append("int");
                break;
            }
            case LONG: {
                builder.append("bigint");
                break;
            }
            case FLOAT: {
                builder.append("float");
                break;
            }
            case DOUBLE: {
                builder.append("double");
                break;
            }
            case BYTES: {
                builder.append("binary");
                break;
            }
            case STRING: {
                builder.append("string");
                break;
            }
            case ARRAY: {
                builder.append("array<");
                HiveSchemaConverter.appendType(builder, schema.getComponentSchema());
                builder.append(">");
                break;
            }
            case MAP: {
                builder.append("map<");
                Map.Entry mapSchema = schema.getMapSchema();
                HiveSchemaConverter.appendType(builder, (Schema)mapSchema.getKey());
                builder.append(",");
                HiveSchemaConverter.appendType(builder, (Schema)mapSchema.getValue());
                builder.append(">");
                break;
            }
            case RECORD: {
                builder.append("struct<");
                Iterator fieldIter = schema.getFields().iterator();
                HiveSchemaConverter.appendField(builder, (Schema.Field)fieldIter.next(), true);
                while (fieldIter.hasNext()) {
                    builder.append(",");
                    HiveSchemaConverter.appendField(builder, (Schema.Field)fieldIter.next(), true);
                }
                builder.append(">");
                break;
            }
            case UNION: {
                if (schema.isNullable()) {
                    HiveSchemaConverter.appendType(builder, schema.getNonNullable());
                    break;
                }
                throw new UnsupportedTypeException("Unions are currently not supported");
            }
        }
    }

    private static void appendField(StringBuilder builder, Schema.Field field, boolean inStruct) throws UnsupportedTypeException {
        String name = field.getName();
        builder.append(name);
        builder.append(inStruct ? ":" : " ");
        HiveSchemaConverter.appendType(builder, field.getSchema());
    }
}

