/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common;

import io.cdap.cdap.etl.api.FailureCollector;
import java.util.regex.Pattern;

public final class IdUtils {
    private static final Pattern datasetIdPattern = Pattern.compile("[$\\.a-zA-Z0-9_-]+");

    private IdUtils() {
    }

    public static void validateId(String id) throws IllegalArgumentException {
        if (!datasetIdPattern.matcher(id).matches()) {
            throw new IllegalArgumentException(String.format("Invalid id '%s'. Supported characters are: letters, numbers, and '_', '-', '.', or '$'.", id));
        }
    }

    public static void validateReferenceName(String referenceName, FailureCollector collector) {
        if (!datasetIdPattern.matcher(referenceName).matches()) {
            collector.addFailure(String.format("Invalid reference name '%s'.", referenceName), "Supported characters are: letters, numbers, and '_', '-', '.', or '$'.").withConfigProperty("referenceName");
        }
    }
}

