/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common;

import com.google.common.base.Splitter;
import io.cdap.cdap.api.dataset.lib.KeyValue;
import java.util.Iterator;
import java.util.regex.Pattern;

public class KeyValueListParser {
    private final Pattern pairDelimiter;
    private final Pattern keyValDelimiter;
    public static final KeyValueListParser DEFAULT = new KeyValueListParser(",", ":");

    public KeyValueListParser(String pairDelimiterRegex, String keyValDelimiterRegex) {
        this.pairDelimiter = Pattern.compile(pairDelimiterRegex);
        this.keyValDelimiter = Pattern.compile(keyValDelimiterRegex);
    }

    public Iterable<KeyValue<String, String>> parse(String kvList) {
        return new KeyValueIterable(kvList);
    }

    private class KeyValueIterator
    implements Iterator<KeyValue<String, String>> {
        private final Iterator<String> pairIter;

        private KeyValueIterator(String kvList) {
            this.pairIter = Splitter.on((Pattern)KeyValueListParser.this.pairDelimiter).trimResults().split((CharSequence)kvList).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.pairIter.hasNext();
        }

        @Override
        public KeyValue<String, String> next() {
            String pair = this.pairIter.next();
            Iterator keyValIter = Splitter.on((Pattern)KeyValueListParser.this.keyValDelimiter).trimResults().split((CharSequence)pair).iterator();
            String key = (String)keyValIter.next();
            if (!keyValIter.hasNext()) {
                throw new IllegalArgumentException(String.format("Invalid syntax for key-value pair in list: %s. It is expected to be a string separated by exactly one %s", pair, KeyValueListParser.this.keyValDelimiter));
            }
            String val = (String)keyValIter.next();
            if (keyValIter.hasNext()) {
                throw new IllegalArgumentException(String.format("Invalid syntax for key-value pair in list: %s. It is expected to be a string separated by exactly one %s", pair, KeyValueListParser.this.keyValDelimiter));
            }
            return new KeyValue((Object)key, (Object)val);
        }

        @Override
        public void remove() {
        }
    }

    private class KeyValueIterable
    implements Iterable<KeyValue<String, String>> {
        private final String kvList;

        private KeyValueIterable(String kvList) {
            this.kvList = kvList;
        }

        @Override
        public Iterator<KeyValue<String, String>> iterator() {
            return new KeyValueIterator(this.kvList);
        }
    }
}

