/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common;

import com.google.common.annotations.VisibleForTesting;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.plugin.PluginConfig;
import javax.annotation.Nullable;

public class KeystoreConf
extends PluginConfig {
    @Description(value="Transformation algorithm, mode, and padding, separated by slashes; for example: AES/CBC/PKCS5Padding")
    @Macro
    private String transformation;
    @Nullable
    @Description(value="Initialization vector if using CBC mode")
    @Macro
    private String ivHex;
    @Description(value="Path to the keystore on local disk; the keystore must be present on every node of the cluster")
    @Macro
    private String keystorePath;
    @Nullable
    @Description(value="Password for the keystore")
    @Macro
    private String keystorePassword;
    @Description(value="Type of keystore; for example: JKS or JCEKS")
    @Macro
    private String keystoreType;
    @Description(value="Alias of the key to use in the keystore")
    @Macro
    private String keyAlias;
    @Description(value="Password for the key to use in the keystore")
    @Macro
    private String keyPassword;

    public KeystoreConf() {
    }

    @VisibleForTesting
    public KeystoreConf(String transformation, @Nullable String ivHex, String keystorePath, String keystorePassword, String keystoreType, String keyAlias, String keyPassword) {
        this.transformation = transformation;
        this.ivHex = ivHex;
        this.keystorePath = keystorePath;
        this.keystorePassword = keystorePassword;
        this.keystoreType = keystoreType;
        this.keyAlias = keyAlias;
        this.keyPassword = keyPassword;
    }

    public String getTransformation() {
        return this.transformation;
    }

    @Nullable
    public String getIvHex() {
        return this.ivHex;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }
}

