/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common;

import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.dataset.DatasetManagementException;
import io.cdap.cdap.api.dataset.DatasetProperties;
import io.cdap.cdap.api.dataset.InstanceConflictException;
import io.cdap.cdap.api.lineage.field.EndPoint;
import io.cdap.cdap.etl.api.batch.BatchContext;
import io.cdap.cdap.etl.api.lineage.field.FieldReadOperation;
import io.cdap.cdap.etl.api.lineage.field.FieldWriteOperation;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class LineageRecorder {
    private final BatchContext context;
    private final String dataset;

    public LineageRecorder(BatchContext context, String dataset) {
        this.context = context;
        this.dataset = dataset;
    }

    public void createExternalDataset(@Nullable Schema schema) {
        DatasetProperties datasetProperties = schema == null ? DatasetProperties.EMPTY : DatasetProperties.of(Collections.singletonMap("schema", schema.toString()));
        try {
            if (!this.context.datasetExists(this.dataset)) {
                this.context.createDataset(this.dataset, "externalDataset", datasetProperties);
            }
        }
        catch (InstanceConflictException e) {
            return;
        }
        catch (DatasetManagementException e) {
            throw new RuntimeException(String.format("Failed to create dataset %s with schema %s.", this.dataset, schema), e);
        }
    }

    public void recordRead(String operationName, String operationDescription, List<String> fields) {
        this.context.record(Collections.singletonList(new FieldReadOperation(operationName, operationDescription, EndPoint.of((String)this.context.getNamespace(), (String)this.dataset), fields)));
    }

    public void recordWrite(String operationName, String operationDescription, List<String> fields) {
        this.context.record(Collections.singletonList(new FieldWriteOperation(operationName, operationDescription, EndPoint.of((String)this.context.getNamespace(), (String)this.dataset), fields)));
    }
}

