/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.cdap.cdap.api.data.format.UnexpectedFormatException;
import io.cdap.cdap.api.data.schema.Schema;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class RecordConverter<INPUT, OUTPUT> {
    public abstract OUTPUT transform(INPUT var1, Schema var2) throws IOException;

    private Object convertUnion(Object value, List<Schema> schemas) {
        boolean isNullable = false;
        for (Schema possibleSchema : schemas) {
            if (possibleSchema.getType() == Schema.Type.NULL) {
                isNullable = true;
                if (value != null) continue;
                return value;
            }
            try {
                return this.convertField(value, possibleSchema);
            }
            catch (Exception exception) {
            }
        }
        if (isNullable) {
            return null;
        }
        throw new UnexpectedFormatException("unable to determine union type.");
    }

    private List<Object> convertArray(Object values, Schema elementSchema) throws IOException {
        ArrayList output;
        if (values instanceof List) {
            List valuesList = (List)values;
            output = Lists.newArrayListWithCapacity((int)valuesList.size());
            for (Object value : valuesList) {
                output.add(this.convertField(value, elementSchema));
            }
        } else {
            int length = Array.getLength(values);
            output = Lists.newArrayListWithCapacity((int)length);
            for (int i = 0; i < length; ++i) {
                output.add(this.convertField(Array.get(values, i), elementSchema));
            }
        }
        return output;
    }

    private Map<Object, Object> convertMap(Map<Object, Object> map, Schema keySchema, Schema valueSchema) throws IOException {
        HashMap converted = Maps.newHashMap();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            converted.put(this.convertField(entry.getKey(), keySchema), this.convertField(entry.getValue(), valueSchema));
        }
        return converted;
    }

    protected Object convertField(Object field, Schema.Field schemaField) throws IOException {
        try {
            return this.convertField(field, schemaField.getSchema());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Error converting field '%s': %s", schemaField.getName(), e.getMessage()), e);
        }
    }

    protected Object convertField(Object field, Schema fieldSchema) throws IOException {
        Schema.Type fieldType = fieldSchema.getType();
        if (fieldType == Schema.Type.UNION) {
            return this.convertUnion(field, fieldSchema.getUnionSchemas());
        }
        if (field == null) {
            throw new NullPointerException("Found a null value for a non-nullable field.");
        }
        switch (fieldType) {
            case RECORD: {
                return this.transform(field, fieldSchema);
            }
            case ARRAY: {
                return this.convertArray(field, fieldSchema.getComponentSchema());
            }
            case MAP: {
                Map.Entry mapSchema = fieldSchema.getMapSchema();
                return this.convertMap((Map)field, (Schema)mapSchema.getKey(), (Schema)mapSchema.getValue());
            }
            case NULL: {
                return null;
            }
            case STRING: {
                return field.toString();
            }
            case BYTES: {
                return this.convertBytes(field);
            }
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                return field;
            }
        }
        throw new UnexpectedFormatException("field type " + fieldType + " is not supported.");
    }

    protected Object convertBytes(Object field) {
        return field;
    }
}

